/*
 * Decompiled with CFR 0.152.
 */
package jp.openstandia.midpoint.grpc;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectValue;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.crypto.EncryptionException;
import com.evolveum.midpoint.prism.crypto.ProtectedData;
import com.evolveum.midpoint.prism.crypto.Protector;
import com.evolveum.midpoint.prism.impl.PrismPropertyValueImpl;
import com.evolveum.midpoint.prism.impl.query.builder.QueryBuilder;
import com.evolveum.midpoint.prism.path.ItemName;
import com.evolveum.midpoint.prism.path.ItemPath;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.prism.query.ObjectOrdering;
import com.evolveum.midpoint.prism.query.ObjectPaging;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.prism.query.OrderDirection;
import com.evolveum.midpoint.prism.query.OrgFilter;
import com.evolveum.midpoint.prism.query.builder.S_AtomicFilterEntry;
import com.evolveum.midpoint.prism.query.builder.S_AtomicFilterExit;
import com.evolveum.midpoint.prism.query.builder.S_FilterEntry;
import com.evolveum.midpoint.prism.query.builder.S_FilterEntryOrEmpty;
import com.evolveum.midpoint.prism.query.builder.S_MatchingRuleEntry;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.GetOperationOptions;
import com.evolveum.midpoint.schema.SelectorOptions;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.util.LocalizableMessage;
import com.evolveum.midpoint.util.LocalizableMessageList;
import com.evolveum.midpoint.util.SingleLocalizableMessage;
import com.evolveum.midpoint.util.exception.PolicyViolationException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AbstractRoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ArchetypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AssignmentHolderType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ExtensionType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.FocusType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.OrgType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.RoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ServiceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.UserType;
import com.evolveum.prism.xml.ns._public.query_3.SearchFilterType;
import com.evolveum.prism.xml.ns._public.types_3.PolyStringType;
import com.evolveum.prism.xml.ns._public.types_3.ProtectedStringType;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import jp.openstandia.midpoint.grpc.AndFilterMessage;
import jp.openstandia.midpoint.grpc.AssignmentMessage;
import jp.openstandia.midpoint.grpc.BuilderWrapper;
import jp.openstandia.midpoint.grpc.BytesMessage;
import jp.openstandia.midpoint.grpc.DefaultObjectType;
import jp.openstandia.midpoint.grpc.DefaultRelationType;
import jp.openstandia.midpoint.grpc.DefaultUserTypePath;
import jp.openstandia.midpoint.grpc.FilterEntryMessage;
import jp.openstandia.midpoint.grpc.FilterInOidMessage;
import jp.openstandia.midpoint.grpc.FilterOrgReferenceMessage;
import jp.openstandia.midpoint.grpc.FilterOrgRootMessage;
import jp.openstandia.midpoint.grpc.FilterReferenceMessage;
import jp.openstandia.midpoint.grpc.IntegerMessage;
import jp.openstandia.midpoint.grpc.ItemMessage;
import jp.openstandia.midpoint.grpc.ItemPathMessage;
import jp.openstandia.midpoint.grpc.LongMessage;
import jp.openstandia.midpoint.grpc.Message;
import jp.openstandia.midpoint.grpc.MessageList;
import jp.openstandia.midpoint.grpc.NotFilterMessage;
import jp.openstandia.midpoint.grpc.ObjectFilterMessage;
import jp.openstandia.midpoint.grpc.ObjectOrderingMessage;
import jp.openstandia.midpoint.grpc.OrFilterMessage;
import jp.openstandia.midpoint.grpc.OrderDirectionType;
import jp.openstandia.midpoint.grpc.OrgFilterScope;
import jp.openstandia.midpoint.grpc.OrgTypeMessage;
import jp.openstandia.midpoint.grpc.PagingMessage;
import jp.openstandia.midpoint.grpc.PolicyError;
import jp.openstandia.midpoint.grpc.PolyStringMessage;
import jp.openstandia.midpoint.grpc.PrismContainerMessage;
import jp.openstandia.midpoint.grpc.PrismContainerValueMessage;
import jp.openstandia.midpoint.grpc.PrismObjectMessage;
import jp.openstandia.midpoint.grpc.PrismPropertyMessage;
import jp.openstandia.midpoint.grpc.PrismPropertyValueMessage;
import jp.openstandia.midpoint.grpc.PrismReferenceMessage;
import jp.openstandia.midpoint.grpc.PrismValueMessage;
import jp.openstandia.midpoint.grpc.QNameMessage;
import jp.openstandia.midpoint.grpc.QueryMessage;
import jp.openstandia.midpoint.grpc.ReferenceMessage;
import jp.openstandia.midpoint.grpc.RoleTypeMessage;
import jp.openstandia.midpoint.grpc.SelfServiceResource;
import jp.openstandia.midpoint.grpc.ServiceTypeMessage;
import jp.openstandia.midpoint.grpc.SingleMessage;
import jp.openstandia.midpoint.grpc.UserTypeMessage;
import shaded.com.google.protobuf.ByteString;

public class TypeConverter {
    private static final Trace LOGGER = TraceManager.getTrace(SelfServiceResource.class);
    private static Map<DefaultUserTypePath, ItemName> userTypeMap = new HashMap<DefaultUserTypePath, ItemName>();

    public static ItemName toItemName(DefaultUserTypePath path) {
        ItemName itemName = userTypeMap.get((Object)path);
        if (itemName == null) {
            throw new UnsupportedOperationException((Object)((Object)path) + " is not supported");
        }
        return itemName;
    }

    public static List toRealValue(List<String> values, Class clazz) {
        return values.stream().map(x -> TypeConverter.toRealValue(x, clazz)).collect(Collectors.toList());
    }

    public static Object toRealValue(String value, Class clazz) {
        if (clazz.isAssignableFrom(String.class)) {
            return value;
        }
        if (clazz.isAssignableFrom(PolyString.class)) {
            return PolyString.fromOrig((String)value);
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return Long.parseLong(value);
        }
        if (clazz.isAssignableFrom(ProtectedStringType.class)) {
            ProtectedStringType p = new ProtectedStringType();
            p.setClearValue((Object)value);
            return p;
        }
        throw new UnsupportedOperationException(clazz + " is not supported");
    }

    public static PolicyError toPolicyError(PolicyViolationException e) {
        PolicyError.Builder builder = PolicyError.newBuilder();
        Message wrapper = null;
        LocalizableMessage msg = e.getUserFriendlyMessage();
        if (msg instanceof SingleLocalizableMessage) {
            wrapper = TypeConverter.toMessage((SingleLocalizableMessage)msg);
        } else if (msg instanceof LocalizableMessageList) {
            wrapper = TypeConverter.toMessage((LocalizableMessageList)msg);
        } else if (msg == null) {
            wrapper = TypeConverter.toIterableMessages(new Object[]{e.getMessage()}).iterator().next();
        }
        if (wrapper == null) {
            throw new UnsupportedOperationException(msg.getClass() + " is not supported");
        }
        builder.setMessage(wrapper);
        return builder.build();
    }

    private static Message toMessage(LocalizableMessageList list) {
        MessageList messageList = TypeConverter.toMessageList(list);
        return Message.newBuilder().setList(messageList).build();
    }

    private static MessageList toMessageList(LocalizableMessageList list) {
        MessageList.Builder builder = MessageList.newBuilder();
        for (LocalizableMessage msg : list.getMessages()) {
            Message wrapper = null;
            if (msg instanceof SingleLocalizableMessage) {
                wrapper = TypeConverter.toMessage((SingleLocalizableMessage)msg);
            } else if (msg instanceof LocalizableMessageList) {
                wrapper = TypeConverter.toMessage((LocalizableMessageList)msg);
            }
            if (wrapper == null) {
                throw new UnsupportedOperationException(msg.getClass() + " is not supported");
            }
            builder.addMessage(wrapper);
        }
        return builder.build();
    }

    private static Message toMessage(SingleLocalizableMessage msg) {
        return Message.newBuilder().setSingle(TypeConverter.toSingleMessage(msg)).build();
    }

    private static SingleMessage toSingleMessage(SingleLocalizableMessage msg) {
        return SingleMessage.newBuilder().setKey(msg.getKey()).addAllArgs(TypeConverter.toIterableMessages(msg.getArgs())).build();
    }

    private static Iterable<? extends Message> toIterableMessages(Object[] args) {
        ArrayList<Message> list = new ArrayList<Message>();
        for (Object arg : args) {
            Message wrapper = arg instanceof SingleLocalizableMessage ? TypeConverter.toMessage((SingleLocalizableMessage)arg) : (arg instanceof LocalizableMessageList ? TypeConverter.toMessage((LocalizableMessageList)arg) : Message.newBuilder().setString(arg != null ? arg.toString() : "").build());
            list.add(wrapper);
        }
        return list;
    }

    public static String toStringMessage(String string) {
        if (string == null) {
            return null;
        }
        return string;
    }

    public static BytesMessage toBytesMessage(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return BytesMessage.newBuilder().setValue(ByteString.copyFrom((byte[])bytes)).build();
    }

    public static PolyStringMessage toPolyStringMessage(PolyString polyString) {
        if (polyString == null) {
            return null;
        }
        return PolyStringMessage.newBuilder().setOrig(polyString.getOrig()).setNorm(polyString.getNorm()).build();
    }

    public static IntegerMessage toIntegerMessage(Integer value) {
        if (value == null) {
            return null;
        }
        return IntegerMessage.newBuilder().setValue(value).build();
    }

    public static LongMessage toLongMessage(Long value) {
        if (value == null) {
            return null;
        }
        return LongMessage.newBuilder().setValue(value).build();
    }

    public static PolyStringMessage toPolyStringMessage(PolyStringType polyStringType) {
        if (polyStringType == null) {
            return null;
        }
        return PolyStringMessage.newBuilder().setOrig(polyStringType.getOrig()).setNorm(polyStringType.getNorm()).build();
    }

    public static List<PolyStringMessage> toPolyStringMessageList(List<PolyStringType> polyStringType) {
        return polyStringType.stream().map(x -> TypeConverter.toPolyStringMessage(x)).collect(Collectors.toList());
    }

    public static List<ReferenceMessage> toReferenceMessageList(List<ObjectReferenceType> ref, Map<String, AbstractRoleType> resolved) {
        return ref.stream().map(x -> TypeConverter.toReferenceMessage(x, (AbstractRoleType)resolved.get(x.getOid()))).collect(Collectors.toList());
    }

    private static ReferenceMessage toReferenceMessage(ItemDefinition definition, PrismReferenceValue value) {
        return TypeConverter.toReferenceMessage((ObjectReferenceType)value.getRealValue(), null);
    }

    public static ReferenceMessage toReferenceMessage(ObjectReferenceType ref, AbstractRoleType resolved) {
        if (ref == null) {
            return null;
        }
        if (ref.getOid() == null) {
            LOGGER.warn("ref's oid is null, ref: {}", (Object)ref);
            return null;
        }
        QName type = ref.getType();
        QName relation = ref.getRelation();
        ReferenceMessage.Builder builder = ((ReferenceMessage.Builder)BuilderWrapper.wrap((Object)ReferenceMessage.newBuilder()).nullSafe((Object)TypeConverter.toPolyStringMessage(ref.getTargetName()), (b, v) -> b.setName((PolyStringMessage)v)).unwrap()).setOid(ref.getOid()).setType(TypeConverter.toQNameMessage(type)).setRelation(TypeConverter.toQNameMessage(relation));
        if (resolved != null) {
            builder = (ReferenceMessage.Builder)BuilderWrapper.wrap((Object)builder).nullSafe((Object)TypeConverter.toPolyStringMessage(resolved.getName()), (b, v) -> b.setName((PolyStringMessage)v)).nullSafe((Object)TypeConverter.toPolyStringMessage(resolved.getDisplayName()), (b, v) -> b.setDisplayName((PolyStringMessage)v)).nullSafe((Object)TypeConverter.toStringMessage(resolved.getDescription()), (b, v) -> b.setDescription((String)v)).nullSafe((Object)TypeConverter.toStringMessage(resolved.getEmailAddress()), (b, v) -> b.setEmailAddress((String)v)).unwrap();
        }
        return builder.build();
    }

    public static QNameMessage toQNameMessage(QName qname) {
        return QNameMessage.newBuilder().setNamespaceURI(qname.getNamespaceURI()).setLocalPart(qname.getLocalPart()).setPrefix(qname.getPrefix()).build();
    }

    public static String toStringValue(String message) {
        if (message == null || message.isEmpty()) {
            return null;
        }
        return message;
    }

    public static byte[] toByteArrayValue(BytesMessage message) {
        if (message.getBytesOptionalCase() == BytesMessage.BytesOptionalCase.BYTESOPTIONAL_NOT_SET) {
            return null;
        }
        return message.getValue().toByteArray();
    }

    public static PolyStringType toPolyStringTypeValue(PolyStringMessage message) {
        if (TypeConverter.isEmpty(message)) {
            return null;
        }
        return new PolyStringType(new PolyString(message.getOrig(), message.getNorm()));
    }

    public static Integer toIntegerValue(IntegerMessage message) {
        if (message.getIntOptionalCase() == IntegerMessage.IntOptionalCase.INTOPTIONAL_NOT_SET) {
            return null;
        }
        return message.getValue();
    }

    public static Long toLongValue(LongMessage message) {
        if (message.getLongOptionalCase() == LongMessage.LongOptionalCase.LONGOPTIONAL_NOT_SET) {
            return null;
        }
        return message.getValue();
    }

    public static List<? extends AssignmentType> toAssignmentTypeListValue(PrismContext prismContext, List<AssignmentMessage> assignmentList) {
        return assignmentList.stream().map(x -> TypeConverter.toAssignmentTypeValue(prismContext, x)).filter(x -> x != null).collect(Collectors.toList());
    }

    public static AssignmentType toAssignmentTypeValue(PrismContext prismContext, AssignmentMessage message) {
        AssignmentType assignment = new AssignmentType();
        assignment.setTargetRef(TypeConverter.toObjectReferenceTypeValue(prismContext, message.getTargetRef()));
        if (message.hasOrgRef()) {
            assignment.setOrgRef(TypeConverter.toObjectReferenceTypeValue(prismContext, message.getOrgRef()));
        }
        if (!message.getExtensionMap().isEmpty()) {
            try {
                prismContext.adopt((Containerable)assignment);
                TypeConverter.addExtensionType(prismContext, assignment.asPrismContainerValue(), message.getExtensionMap());
            }
            catch (SchemaException e) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription("invalid_assignment_extension").asRuntimeException();
                throw exception;
            }
        }
        return assignment;
    }

    private static Class<? extends Containerable> toObjectClass(QName type) {
        if (type == ObjectType.COMPLEX_TYPE) {
            return ObjectType.class;
        }
        if (type == FocusType.COMPLEX_TYPE) {
            return FocusType.class;
        }
        if (type == AssignmentHolderType.COMPLEX_TYPE) {
            return AssignmentHolderType.class;
        }
        if (type == UserType.COMPLEX_TYPE) {
            return UserType.class;
        }
        if (type == AbstractRoleType.COMPLEX_TYPE) {
            return AbstractRoleType.class;
        }
        if (type == RoleType.COMPLEX_TYPE) {
            return RoleType.class;
        }
        if (type == OrgType.COMPLEX_TYPE) {
            return OrgType.class;
        }
        if (type == ServiceType.COMPLEX_TYPE) {
            return ServiceType.class;
        }
        return ObjectType.class;
    }

    public static ObjectQuery toObjectQuery(PrismContext prismContext, Class<? extends Containerable> queryClass, QueryMessage message) {
        S_FilterEntryOrEmpty builder = QueryBuilder.queryFor(queryClass, (PrismContext)prismContext);
        S_AtomicFilterExit exitFilter = TypeConverter.toObjectFilter(prismContext, builder, message.getFilter());
        Object exitBuilder = exitFilter != null ? exitFilter : builder;
        ObjectQuery query = exitBuilder.build();
        query.setPaging(TypeConverter.toObjectPaging(prismContext, message.getPaging()));
        return query;
    }

    public static ObjectPaging toObjectPaging(PrismContext prismContext, PagingMessage message) {
        ObjectPaging paging = prismContext.queryFactory().createPaging();
        paging.setOffset(Integer.valueOf(message.getOffset()));
        if (message.getMaxSize() != 0) {
            paging.setMaxSize(Integer.valueOf(message.getMaxSize()));
        }
        paging.setOrdering(TypeConverter.toObjectOrdering(prismContext, message.getOrderingList()));
        return paging;
    }

    public static Collection<? extends ObjectOrdering> toObjectOrdering(PrismContext prismContext, List<ObjectOrderingMessage> message) {
        return message.stream().map(x -> {
            OrderDirection direction = TypeConverter.toOrderDirectionValue(x.getOrderDirection());
            String orderBy = x.getOrderBy();
            ItemPath itemPath = TypeConverter.toItemPath(orderBy);
            return prismContext.queryFactory().createOrdering(itemPath, direction);
        }).collect(Collectors.toList());
    }

    private static OrderDirection toOrderDirectionValue(OrderDirectionType message) {
        switch (message) {
            case ASCEDING: {
                return OrderDirection.ASCENDING;
            }
            case DESCENDING: {
                return OrderDirection.DESCENDING;
            }
        }
        return OrderDirection.ASCENDING;
    }

    public static S_AtomicFilterExit toObjectFilter(PrismContext prismContext, S_FilterEntryOrEmpty builder, ObjectFilterMessage message) {
        if (message.hasAnd()) {
            return TypeConverter.toAndQuery(prismContext, (S_FilterEntry)builder, message.getAnd());
        }
        if (message.hasOr()) {
            return TypeConverter.toOrQuery(prismContext, (S_FilterEntry)builder, message.getOr());
        }
        if (message.hasNot()) {
            return TypeConverter.toNotQuery(prismContext, builder, message.getNot());
        }
        if (message.hasEq()) {
            return TypeConverter.toEqFilter(builder, message.getEq());
        }
        if (message.hasStartsWith()) {
            return TypeConverter.toStartsWithFilter(builder, message.getStartsWith());
        }
        if (message.hasContains()) {
            return TypeConverter.toContainsFilter(builder, message.getContains());
        }
        if (message.hasEndsWith()) {
            return TypeConverter.toEndsWithFilter(builder, message.getEndsWith());
        }
        if (message.hasEqPolyString()) {
            return TypeConverter.toEqPolyFilter(builder, message.getEqPolyString());
        }
        if (message.hasStartsWithPolyString()) {
            return TypeConverter.toStartsWithPolyFilter(builder, message.getStartsWithPolyString());
        }
        if (message.hasContainsPolyString()) {
            return TypeConverter.toContainsPolyFilter(builder, message.getContainsPolyString());
        }
        if (message.hasEndsWithPolyString()) {
            return TypeConverter.toEndsWithPolyFilter(builder, message.getEndsWithPolyString());
        }
        if (message.hasInOid()) {
            return TypeConverter.toInOidFilter(prismContext, builder, message.getInOid());
        }
        if (message.hasRef()) {
            return TypeConverter.toRefFilter(prismContext, builder, message.getRef());
        }
        if (message.hasOrgRoot()) {
            return TypeConverter.toOrgRootFilter(prismContext, builder, message.getOrgRoot());
        }
        if (message.hasOrgRef()) {
            return TypeConverter.toOrgRefFilter(prismContext, builder, message.getOrgRef());
        }
        return null;
    }

    public static S_AtomicFilterExit toObjectFilter(PrismContext prismContext, S_FilterEntry builder, ObjectFilterMessage message) {
        if (message.hasAnd()) {
            return TypeConverter.toAndQuery(prismContext, builder, message.getAnd());
        }
        if (message.hasOr()) {
            return TypeConverter.toOrQuery(prismContext, builder, message.getOr());
        }
        if (builder instanceof S_FilterEntryOrEmpty) {
            return TypeConverter.toObjectFilter(prismContext, (S_FilterEntryOrEmpty)builder, message);
        }
        return null;
    }

    public static ItemPath toItemPath(FilterEntryMessage message) {
        return TypeConverter.toItemPath(message.getFullPath());
    }

    public static ItemPath toItemPath(String message) {
        return ItemPath.create(Arrays.stream(message.split("/")).map(x -> {
            try {
                if (x.startsWith("[") && x.endsWith("]")) {
                    return Long.valueOf(Long.parseLong(x.substring(1, x.length() - 1)));
                }
                return x;
            }
            catch (NumberFormatException e) {
                return x;
            }
        }).collect(Collectors.toList()));
    }

    public static S_AtomicFilterExit toEqFilter(S_FilterEntryOrEmpty builder, FilterEntryMessage message) {
        S_MatchingRuleEntry filter = builder.item(TypeConverter.toItemPath(message)).eq(new Object[]{message.getValue()});
        if (message.hasMatchingRule()) {
            return filter.matching(TypeConverter.toQNameValue(message.getMatchingRule()));
        }
        return filter;
    }

    public static S_AtomicFilterExit toStartsWithFilter(S_FilterEntryOrEmpty builder, FilterEntryMessage message) {
        S_MatchingRuleEntry filter = builder.item(TypeConverter.toItemPath(message)).startsWith((Object)message.getValue());
        if (message.hasMatchingRule()) {
            return filter.matching(TypeConverter.toQNameValue(message.getMatchingRule()));
        }
        return filter;
    }

    private static S_AtomicFilterExit toContainsFilter(S_FilterEntryOrEmpty builder, FilterEntryMessage message) {
        S_MatchingRuleEntry filter = builder.item(TypeConverter.toItemPath(message)).contains((Object)message.getValue());
        if (message.hasMatchingRule()) {
            return filter.matching(TypeConverter.toQNameValue(message.getMatchingRule()));
        }
        return filter;
    }

    public static S_AtomicFilterExit toEndsWithFilter(S_FilterEntryOrEmpty builder, FilterEntryMessage message) {
        S_MatchingRuleEntry filter = builder.item(TypeConverter.toItemPath(message)).endsWith((Object)message.getValue());
        if (message.hasMatchingRule()) {
            return filter.matching(TypeConverter.toQNameValue(message.getMatchingRule()));
        }
        return filter;
    }

    public static S_AtomicFilterExit toEqPolyFilter(S_FilterEntryOrEmpty builder, FilterEntryMessage message) {
        S_MatchingRuleEntry filter = builder.item(TypeConverter.toItemPath(message)).eqPoly(message.getValue());
        if (message.hasMatchingRule()) {
            return filter.matching(TypeConverter.toQNameValue(message.getMatchingRule()));
        }
        return filter;
    }

    public static S_AtomicFilterExit toStartsWithPolyFilter(S_FilterEntryOrEmpty builder, FilterEntryMessage message) {
        S_MatchingRuleEntry filter = builder.item(TypeConverter.toItemPath(message)).startsWithPoly(message.getValue());
        if (message.hasMatchingRule()) {
            return filter.matching(TypeConverter.toQNameValue(message.getMatchingRule()));
        }
        return filter;
    }

    private static S_AtomicFilterExit toContainsPolyFilter(S_FilterEntryOrEmpty builder, FilterEntryMessage message) {
        S_MatchingRuleEntry filter = builder.item(TypeConverter.toItemPath(message)).containsPoly(message.getValue());
        if (message.hasMatchingRule()) {
            return filter.matching(TypeConverter.toQNameValue(message.getMatchingRule()));
        }
        return filter;
    }

    public static S_AtomicFilterExit toEndsWithPolyFilter(S_FilterEntryOrEmpty builder, FilterEntryMessage message) {
        S_MatchingRuleEntry filter = builder.item(TypeConverter.toItemPath(message)).endsWithPoly(message.getValue());
        if (message.hasMatchingRule()) {
            return filter.matching(TypeConverter.toQNameValue(message.getMatchingRule()));
        }
        return filter;
    }

    public static S_AtomicFilterExit toAndQuery(PrismContext prismContext, S_FilterEntry builder, AndFilterMessage message) {
        List<ObjectFilterMessage> list = message.getConditionsList();
        for (int i = 0; i < list.size(); ++i) {
            ObjectFilterMessage filter = list.get(i);
            S_AtomicFilterExit f = TypeConverter.toObjectFilter(prismContext, builder, filter);
            if (i >= list.size() - 1) {
                return f;
            }
            builder = f.and();
        }
        return null;
    }

    public static S_AtomicFilterExit toOrQuery(PrismContext prismContext, S_FilterEntry builder, OrFilterMessage message) {
        List<ObjectFilterMessage> list = message.getConditionsList();
        for (int i = 0; i < list.size(); ++i) {
            ObjectFilterMessage filter = list.get(i);
            S_AtomicFilterExit f = TypeConverter.toObjectFilter(prismContext, builder, filter);
            if (i >= list.size() - 1) {
                return f;
            }
            builder = f.or();
        }
        return null;
    }

    public static S_AtomicFilterExit toNotQuery(PrismContext prismContext, S_FilterEntryOrEmpty builder, NotFilterMessage message) {
        S_AtomicFilterEntry not = builder.not();
        S_FilterEntryOrEmpty block = not.block();
        S_AtomicFilterExit q = TypeConverter.toObjectFilter(prismContext, block, message.getFilter());
        return q.endBlock();
    }

    public static SearchFilterType toEqFilter(PrismContext prismContext, QName type, QName findKey, PolyStringMessage message) {
        Class<? extends Containerable> queryClass = TypeConverter.toObjectClass(type);
        ObjectFilter filter = QueryBuilder.queryFor(queryClass, (PrismContext)prismContext).item(new QName[]{findKey}).eqPoly(message.getOrig()).matchingOrig().build().getFilter();
        try {
            return prismContext.getQueryConverter().createSearchFilterType(filter);
        }
        catch (SchemaException e) {
            StatusRuntimeException exception = Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription("invalid_filter").asRuntimeException();
            throw exception;
        }
    }

    public static SearchFilterType toEqFilter(PrismContext prismContext, QName type, QName findKey, String message, QName matchingRule) {
        Class<? extends Containerable> queryClass = TypeConverter.toObjectClass(type);
        ObjectFilter filter = QueryBuilder.queryFor(queryClass, (PrismContext)prismContext).item(new QName[]{findKey}).eq(new Object[]{message}).matching(matchingRule).build().getFilter();
        try {
            return prismContext.getQueryConverter().createSearchFilterType(filter);
        }
        catch (SchemaException e) {
            StatusRuntimeException exception = Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription("invalid_filter").asRuntimeException();
            throw exception;
        }
    }

    public static S_AtomicFilterExit toInOidFilter(PrismContext prismContext, S_FilterEntryOrEmpty builder, FilterInOidMessage message) {
        return builder.id((String[])message.getValueList().toArray((Object[])new String[0]));
    }

    public static S_AtomicFilterExit toRefFilter(PrismContext prismContext, S_FilterEntryOrEmpty builder, FilterReferenceMessage message) {
        ObjectReferenceType ref = TypeConverter.toObjectReferenceTypeValue(prismContext, message.getValue());
        return builder.item(TypeConverter.toItemPath(message)).ref(new PrismReferenceValue[]{ref.asReferenceValue()});
    }

    public static S_AtomicFilterExit toOrgRootFilter(PrismContext prismContext, S_FilterEntryOrEmpty builder, FilterOrgRootMessage message) {
        if (message.getIsRoot()) {
            return builder.isRoot();
        }
        return builder.undefined();
    }

    public static S_AtomicFilterExit toOrgRefFilter(PrismContext prismContext, S_FilterEntryOrEmpty builder, FilterOrgReferenceMessage message) {
        ObjectReferenceType ref = TypeConverter.toObjectReferenceTypeValue(prismContext, message.getValue());
        return builder.isInScopeOf(ref.asReferenceValue(), TypeConverter.toOrgFilterScope(message.getScope()));
    }

    public static OrgFilter.Scope toOrgFilterScope(OrgFilterScope scope) {
        switch (scope) {
            case ONE_LEVEL: {
                return OrgFilter.Scope.ONE_LEVEL;
            }
            case SUBTREE: {
                return OrgFilter.Scope.SUBTREE;
            }
            case ANCESTORS: {
                return OrgFilter.Scope.ANCESTORS;
            }
        }
        return null;
    }

    public static ItemPath toItemPath(FilterReferenceMessage message) {
        return TypeConverter.toItemPath(message.getFullPath());
    }

    public static ObjectReferenceType toObjectReferenceTypeValue(PrismContext prismContext, ReferenceMessage message) {
        ObjectReferenceType ref = new ObjectReferenceType();
        if (message.hasType()) {
            ref.setType(TypeConverter.toQNameValue(message.getType()));
        } else if (message.getTypeWrapperCase() == ReferenceMessage.TypeWrapperCase.OBJECT_TYPE) {
            ref.setType(TypeConverter.toQNameValue(message.getObjectType()));
        }
        QName type = ref.getType();
        if (message.hasName()) {
            ref.setFilter(TypeConverter.toEqFilter(prismContext, type, (QName)ObjectType.F_NAME, message.getName()));
        } else if (!message.getEmailAddress().isEmpty()) {
            ref.setFilter(TypeConverter.toEqFilter(prismContext, type, (QName)FocusType.F_EMAIL_ADDRESS, message.getEmailAddress(), PrismConstants.STRING_IGNORE_CASE_MATCHING_RULE_NAME));
        } else if (!message.getOid().isEmpty()) {
            ref.setOid(message.getOid());
        } else {
            return null;
        }
        if (message.hasRelation()) {
            ref.setRelation(TypeConverter.toQNameValue(message.getRelation()));
        } else if (message.getRelationWrapperCase() == ReferenceMessage.RelationWrapperCase.RELATION_TYPE) {
            ref.setRelation(TypeConverter.toQNameValue(message.getRelationType()));
        } else {
            ref.setRelation(prismContext.getDefaultRelation());
        }
        return ref;
    }

    public static QName toQNameValue(QNameMessage message) {
        if (message.getNamespaceURI().isEmpty() && message.getLocalPart().isEmpty()) {
            return SchemaConstants.ORG_DEFAULT;
        }
        if (message.getNamespaceURI().isEmpty()) {
            return new QName(message.getLocalPart());
        }
        if (message.getPrefix().isEmpty()) {
            return new QName(message.getNamespaceURI(), message.getLocalPart());
        }
        return new QName(message.getNamespaceURI(), message.getLocalPart(), message.getPrefix());
    }

    public static QName toQNameValue(DefaultRelationType type) {
        switch (type) {
            case ORG_DEFAULT: {
                return SchemaConstants.ORG_DEFAULT;
            }
            case ORG_MANAGER: {
                return SchemaConstants.ORG_MANAGER;
            }
            case ORG_META: {
                return SchemaConstants.ORG_META;
            }
            case ORG_DEPUTY: {
                return SchemaConstants.ORG_DEPUTY;
            }
            case ORG_APPROVER: {
                return SchemaConstants.ORG_APPROVER;
            }
            case ORG_OWNER: {
                return SchemaConstants.ORG_OWNER;
            }
            case ORG_CONSENT: {
                return SchemaConstants.ORG_CONSENT;
            }
        }
        return null;
    }

    public static QName toQNameValue(DefaultObjectType type) {
        switch (type) {
            case OBJECT_TYPE: {
                return ObjectType.COMPLEX_TYPE;
            }
            case FOCUS_TYPE: {
                return FocusType.COMPLEX_TYPE;
            }
            case USER_TYPE: {
                return UserType.COMPLEX_TYPE;
            }
            case ABSTRACT_ROLE_TYPE: {
                return AbstractRoleType.COMPLEX_TYPE;
            }
            case ROLE_TYPE: {
                return RoleType.COMPLEX_TYPE;
            }
            case ORG_TYPE: {
                return OrgType.COMPLEX_TYPE;
            }
            case SERVICE_TYPE: {
                return ServiceType.COMPLEX_TYPE;
            }
            case ASSIGNMENT_HOLDER_TYPE: {
                return AssignmentHolderType.COMPLEX_TYPE;
            }
            case ARCHETYPE_TYPE: {
                return ArchetypeType.COMPLEX_TYPE;
            }
        }
        return null;
    }

    public static boolean isEmpty(PolyStringMessage message) {
        return message.getNorm().isEmpty() && message.getOrig().isEmpty();
    }

    public static void addExtensionType(PrismContext prismContext, ObjectType object, Map<String, ItemMessage> map) throws SchemaException {
        if (map.isEmpty()) {
            return;
        }
        TypeConverter.addExtensionType(prismContext, object.asPrismObject(), map);
    }

    public static void addExtensionType(PrismContext prismContext, PrismObject object, Map<String, ItemMessage> map) throws SchemaException {
        if (map.isEmpty()) {
            return;
        }
        PrismContainer extension = object.findOrCreateContainer((ItemPath)ObjectType.F_EXTENSION);
        TypeConverter.addExtensionType(prismContext, extension, map);
    }

    public static void addExtensionType(PrismContext prismContext, PrismContainerValue object, Map<String, ItemMessage> map) throws SchemaException {
        if (map.isEmpty()) {
            return;
        }
        PrismContainer extension = object.findOrCreateContainer((QName)ObjectType.F_EXTENSION);
        TypeConverter.addExtensionType(prismContext, extension, map);
    }

    public static void addExtensionType(PrismContext prismContext, PrismContainer extension, Map<String, ItemMessage> map) throws SchemaException {
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ItemMessage> entry : map.entrySet()) {
            String k = entry.getKey();
            ItemMessage v = entry.getValue();
            QName qname = TypeConverter.toQName(v, k);
            ItemPath path = ItemPath.create((Object[])new Object[]{qname});
            ItemDefinition definition = extension.getDefinition().findItemDefinition(path);
            if (definition == null) {
                throw new SchemaException("No schema: " + qname);
            }
            if (definition instanceof PrismPropertyDefinition) {
                TypeConverter.addExtensionValue(prismContext, extension, (PrismPropertyDefinition)definition, path, v.getProperty());
                continue;
            }
            if (definition instanceof PrismContainerDefinition) {
                TypeConverter.addExtensionValue(prismContext, extension, (PrismContainerDefinition)definition, path, v.getContainer());
                continue;
            }
            if (definition instanceof PrismReferenceDefinition) {
                TypeConverter.addExtensionValue(prismContext, extension, (PrismReferenceDefinition)definition, path, v.getRef());
                continue;
            }
            throw new UnsupportedOperationException(definition.getClass() + " is not supported");
        }
    }

    private static void addExtensionValue(PrismContext prismContext, PrismContainer extension, PrismReferenceDefinition definition, ItemPath path, PrismReferenceMessage ref) throws SchemaException {
        if (ref == null) {
            return;
        }
        PrismReference holder = extension.findOrCreateReference(path);
        if (definition.isSingleValue() && ref.getValuesCount() > 1) {
            throw new SchemaException("Multiple value is used for single value: " + path);
        }
        for (ReferenceMessage value : ref.getValuesList()) {
            holder.add((PrismValue)TypeConverter.toPrismReferenceValue(prismContext, definition, value));
        }
    }

    private static void addExtensionValue(PrismContext prismContext, PrismContainer extension, PrismContainerDefinition definition, ItemPath path, PrismContainerMessage container) throws SchemaException {
        if (container.getValuesCount() == 0) {
            return;
        }
        PrismContainer holder = extension.findOrCreateContainer(path);
        if (definition.isSingleValue() && container.getValuesCount() > 1) {
            throw new SchemaException("Multiple value is used for single value: " + path);
        }
        for (PrismContainerValueMessage value : container.getValuesList()) {
            holder.add((PrismValue)TypeConverter.toPrismContainerValue(prismContext, definition, value));
        }
    }

    private static void addExtensionValue(PrismContext prismContext, PrismContainer extension, PrismPropertyDefinition definition, ItemPath path, PrismPropertyMessage property) throws SchemaException {
        if (property.getValuesCount() == 0) {
            return;
        }
        PrismProperty holder = extension.findOrCreateProperty(path);
        if (definition.isSingleValue() && property.getValuesCount() > 1) {
            throw new SchemaException("Multiple value is used for single value: " + path);
        }
        for (PrismPropertyValueMessage value : property.getValuesList()) {
            holder.add((PrismValue)TypeConverter.toPrismPropertyValue(prismContext, definition, value));
        }
    }

    public static QName toQName(ItemMessage message, String localPart) {
        if (message.getItemName().getNamespaceURI().isEmpty()) {
            return new QName(localPart);
        }
        return new QName(message.getItemName().getNamespaceURI(), localPart, message.getItemName().getPrefix());
    }

    public static QName toQName(PrismValueMessage message, String localPart) {
        if (message.getNamespaceURI().isEmpty()) {
            return new QName(localPart);
        }
        return new QName(message.getNamespaceURI(), localPart);
    }

    public static PrismObject<UserType> toPrismObject(PrismContext prismContext, RepositoryService repo, UserTypeMessage message) throws SchemaException {
        UserType user = new UserType(prismContext);
        PrismContainerDefinition definition = user.asPrismContainerValue().getDefinition();
        user.setName(TypeConverter.toPolyStringTypeValue(message.getName()));
        user.setDescription(TypeConverter.toStringValue(message.getDescription()));
        user.createSubtypeList().addAll(message.getSubtypeList());
        user.setLifecycleState(TypeConverter.toStringValue(message.getLifecycleState()));
        user.createAssignmentList().addAll(TypeConverter.toAssignmentTypeListValue(prismContext, message.getAssignmentList()));
        user.setJpegPhoto(TypeConverter.toByteArrayValue(message.getJpegPhoto()));
        user.setCostCenter(TypeConverter.toStringValue(message.getCostCenter()));
        user.setLocality(TypeConverter.toPolyStringTypeValue(message.getLocality()));
        user.setPreferredLanguage(TypeConverter.toStringValue(message.getPreferredLanguage()));
        user.setLocale(TypeConverter.toStringValue(message.getLocale()));
        user.setTimezone(TypeConverter.toStringValue(message.getTimezone()));
        user.setEmailAddress(TypeConverter.toStringValue(message.getEmailAddress()));
        user.setTelephoneNumber(TypeConverter.toStringValue(message.getTelephoneNumber()));
        user.setFullName(TypeConverter.toPolyStringTypeValue(message.getFullName()));
        user.setGivenName(TypeConverter.toPolyStringTypeValue(message.getGivenName()));
        user.setFamilyName(TypeConverter.toPolyStringTypeValue(message.getFamilyName()));
        user.setAdditionalName(TypeConverter.toPolyStringTypeValue(message.getAdditionalName()));
        user.setNickName(TypeConverter.toPolyStringTypeValue(message.getNickName()));
        user.setHonorificPrefix(TypeConverter.toPolyStringTypeValue(message.getHonorificPrefix()));
        user.setHonorificSuffix(TypeConverter.toPolyStringTypeValue(message.getHonorificSuffix()));
        user.setTitle(TypeConverter.toPolyStringTypeValue(message.getTitle()));
        user.setEmployeeNumber(TypeConverter.toStringValue(message.getEmployeeNumber()));
        user.createOrganizationList().addAll(TypeConverter.toPolyStringTypeValueList(message.getOrganizationList()));
        user.createOrganizationalUnitList().addAll(TypeConverter.toPolyStringTypeValueList(message.getOrganizationalUnitList()));
        TypeConverter.addExtensionType(prismContext, (ObjectType)user, message.getExtensionMap());
        return user.asPrismObject();
    }

    public static PrismObject<RoleType> toPrismObject(PrismContext prismContext, RepositoryService repo, RoleTypeMessage message) throws SchemaException {
        RoleType object = new RoleType(prismContext);
        object.setName(TypeConverter.toPolyStringTypeValue(message.getName()));
        object.setDescription(TypeConverter.toStringValue(message.getDescription()));
        object.createSubtypeList().addAll(message.getSubtypeList());
        object.setLifecycleState(TypeConverter.toStringValue(message.getLifecycleState()));
        object.createAssignmentList().addAll(TypeConverter.toAssignmentTypeListValue(prismContext, message.getAssignmentList()));
        object.setJpegPhoto(TypeConverter.toByteArrayValue(message.getJpegPhoto()));
        object.setCostCenter(TypeConverter.toStringValue(message.getCostCenter()));
        object.setLocality(TypeConverter.toPolyStringTypeValue(message.getLocality()));
        object.setPreferredLanguage(TypeConverter.toStringValue(message.getPreferredLanguage()));
        object.setLocale(TypeConverter.toStringValue(message.getLocale()));
        object.setTimezone(TypeConverter.toStringValue(message.getTimezone()));
        object.setEmailAddress(TypeConverter.toStringValue(message.getEmailAddress()));
        object.setTelephoneNumber(TypeConverter.toStringValue(message.getTelephoneNumber()));
        object.setDisplayName(TypeConverter.toPolyStringTypeValue(message.getDisplayName()));
        object.setIdentifier(TypeConverter.toStringValue(message.getIdentifier()));
        object.setRequestable(TypeConverter.toBooleanValue(message.getRequestable()));
        object.setDelegable(TypeConverter.toBooleanValue(message.getDelegable()));
        object.setRiskLevel(TypeConverter.toStringValue(message.getRiskLevel()));
        object.setRoleType(TypeConverter.toStringValue(message.getRoleType()));
        TypeConverter.addExtensionType(prismContext, (ObjectType)object, message.getExtensionMap());
        return object.asPrismObject();
    }

    public static PrismObject<OrgType> toPrismObject(PrismContext prismContext, RepositoryService repo, OrgTypeMessage message) throws SchemaException {
        OrgType object = new OrgType(prismContext);
        object.setName(TypeConverter.toPolyStringTypeValue(message.getName()));
        object.setDescription(TypeConverter.toStringValue(message.getDescription()));
        object.createSubtypeList().addAll(message.getSubtypeList());
        object.setLifecycleState(TypeConverter.toStringValue(message.getLifecycleState()));
        object.createAssignmentList().addAll(TypeConverter.toAssignmentTypeListValue(prismContext, message.getAssignmentList()));
        object.setJpegPhoto(TypeConverter.toByteArrayValue(message.getJpegPhoto()));
        object.setCostCenter(TypeConverter.toStringValue(message.getCostCenter()));
        object.setLocality(TypeConverter.toPolyStringTypeValue(message.getLocality()));
        object.setPreferredLanguage(TypeConverter.toStringValue(message.getPreferredLanguage()));
        object.setLocale(TypeConverter.toStringValue(message.getLocale()));
        object.setTimezone(TypeConverter.toStringValue(message.getTimezone()));
        object.setEmailAddress(TypeConverter.toStringValue(message.getEmailAddress()));
        object.setTelephoneNumber(TypeConverter.toStringValue(message.getTelephoneNumber()));
        object.setDisplayName(TypeConverter.toPolyStringTypeValue(message.getDisplayName()));
        object.setIdentifier(TypeConverter.toStringValue(message.getIdentifier()));
        object.setRequestable(TypeConverter.toBooleanValue(message.getRequestable()));
        object.setDelegable(TypeConverter.toBooleanValue(message.getDelegable()));
        object.setRiskLevel(TypeConverter.toStringValue(message.getRiskLevel()));
        object.createOrgTypeList().addAll(message.getOrgTypeList());
        object.setTenant(TypeConverter.toBooleanValue(message.getTenant()));
        object.createMailDomainList().addAll(message.getMailDomainList());
        object.setDisplayOrder(TypeConverter.toIntValue(message.getDisplayOrder()));
        TypeConverter.addExtensionType(prismContext, (ObjectType)object, message.getExtensionMap());
        return object.asPrismObject();
    }

    public static PrismObject<ServiceType> toPrismObject(PrismContext prismContext, RepositoryService repo, ServiceTypeMessage message) throws SchemaException {
        ServiceType object = new ServiceType(prismContext);
        object.setName(TypeConverter.toPolyStringTypeValue(message.getName()));
        object.setDescription(TypeConverter.toStringValue(message.getDescription()));
        object.createSubtypeList().addAll(message.getSubtypeList());
        object.setLifecycleState(TypeConverter.toStringValue(message.getLifecycleState()));
        object.createAssignmentList().addAll(TypeConverter.toAssignmentTypeListValue(prismContext, message.getAssignmentList()));
        object.setJpegPhoto(TypeConverter.toByteArrayValue(message.getJpegPhoto()));
        object.setCostCenter(TypeConverter.toStringValue(message.getCostCenter()));
        object.setLocality(TypeConverter.toPolyStringTypeValue(message.getLocality()));
        object.setPreferredLanguage(TypeConverter.toStringValue(message.getPreferredLanguage()));
        object.setLocale(TypeConverter.toStringValue(message.getLocale()));
        object.setTimezone(TypeConverter.toStringValue(message.getTimezone()));
        object.setEmailAddress(TypeConverter.toStringValue(message.getEmailAddress()));
        object.setTelephoneNumber(TypeConverter.toStringValue(message.getTelephoneNumber()));
        object.setDisplayName(TypeConverter.toPolyStringTypeValue(message.getDisplayName()));
        object.setIdentifier(TypeConverter.toStringValue(message.getIdentifier()));
        object.setRequestable(TypeConverter.toBooleanValue(message.getRequestable()));
        object.setDelegable(TypeConverter.toBooleanValue(message.getDelegable()));
        object.setRiskLevel(TypeConverter.toStringValue(message.getRiskLevel()));
        object.createServiceTypeList().addAll(message.getServiceTypeList());
        object.setDisplayOrder(TypeConverter.toIntValue(message.getDisplayOrder()));
        object.setUrl(TypeConverter.toStringValue(message.getUrl()));
        TypeConverter.addExtensionType(prismContext, (ObjectType)object, message.getExtensionMap());
        return object.asPrismObject();
    }

    private static Integer toIntValue(int displayOrder) {
        if (displayOrder == 0) {
            return null;
        }
        return displayOrder;
    }

    private static Boolean toBooleanValue(boolean value) {
        if (!value) {
            return null;
        }
        return true;
    }

    public static PrismObject toPrismObject(PrismContext prismContext, Class clazz, PrismContainerMessage message) throws SchemaException {
        PrismContainerDefinition definition = prismContext.getSchemaRegistry().findContainerDefinitionByCompileTimeClass(clazz);
        PrismContainer instantiate = (PrismContainer)definition.instantiate();
        ObjectType objectType = (ObjectType)instantiate.getRealValue();
        List<PrismContainerValueMessage> values = message.getValuesList();
        if (values.size() > 1) {
            StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_schema: PrismObject with more than one value").asRuntimeException();
            throw exception;
        }
        if (values.size() > 0) {
            PrismObjectValue prismObjectValue = TypeConverter.toPrismObjectValue(prismContext, definition, values.get(0), (Objectable)objectType);
            instantiate.setValue((PrismContainerValue)prismObjectValue);
        }
        return objectType.asPrismObject();
    }

    private static List<PolyStringType> toPolyStringTypeValueList(List<PolyStringMessage> organizationList) {
        return organizationList.stream().map(x -> TypeConverter.toPolyStringTypeValue(x)).collect(Collectors.toList());
    }

    public static UserTypeMessage toUserTypeMessage(UserType u, Collection<SelectorOptions<GetOperationOptions>> options) {
        return ((UserTypeMessage.Builder)BuilderWrapper.wrap((Object)UserTypeMessage.newBuilder()).nullSafe((Object)u.getOid(), (b, v) -> b.setOid((String)v)).nullSafe((Object)u.getVersion(), (b, v) -> b.setVersion((String)v)).nullSafe((Object)TypeConverter.toPolyStringMessage(u.getName()), (b, v) -> b.setName((PolyStringMessage)v)).selectOptions(options).nullSafeWithRetrieve((ItemPath)UserType.F_DESCRIPTION, (Object)u.getDescription(), (b, v) -> b.setDescription((String)v)).nullSafeWithRetrieve((ItemPath)UserType.F_SUBTYPE, (Object)u.getSubtype(), (b, v) -> b.addAllSubtype((Iterable<String>)v)).nullSafeWithRetrieve((ItemPath)UserType.F_LIFECYCLE_STATE, (Object)u.getLifecycleState(), (b, v) -> b.setLifecycleState((String)v)).nullSafeWithRetrieve((ItemPath)UserType.F_PARENT_ORG_REF, (Object)u.getParentOrgRef(), (b, v) -> b.addAllParentOrgRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)UserType.F_ASSIGNMENT, (Object)u.getAssignment(), (b, v) -> b.addAllAssignment(v.stream().map(a -> AssignmentMessage.newBuilder().setTargetRef(TypeConverter.toReferenceMessage(a.getTargetRef(), null)).build()).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)UserType.F_ARCHETYPE_REF, (Object)u.getArchetypeRef(), (b, v) -> b.addAllArchetypeRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)UserType.F_ROLE_MEMBERSHIP_REF, (Object)u.getRoleMembershipRef(), (b, v) -> b.addAllRoleMembershipRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)UserType.F_JPEG_PHOTO, (Object)TypeConverter.toBytesMessage(u.getJpegPhoto()), (b, v) -> b.setJpegPhoto((BytesMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_COST_CENTER, (Object)u.getCostCenter(), (b, v) -> b.setCostCenter((String)v)).nullSafeWithRetrieve((ItemPath)UserType.F_LOCALITY, (Object)TypeConverter.toPolyStringMessage(u.getLocality()), (b, v) -> b.setLocality((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_PREFERRED_LANGUAGE, (Object)u.getPreferredLanguage(), (b, v) -> b.setPreferredLanguage((String)v)).nullSafeWithRetrieve((ItemPath)UserType.F_LOCALE, (Object)u.getLocale(), (b, v) -> b.setLocale((String)v)).nullSafeWithRetrieve((ItemPath)UserType.F_TIMEZONE, (Object)u.getTimezone(), (b, v) -> b.setTimezone((String)v)).nullSafeWithRetrieve((ItemPath)UserType.F_EMAIL_ADDRESS, (Object)u.getEmailAddress(), (b, v) -> b.setEmailAddress((String)v)).nullSafeWithRetrieve((ItemPath)UserType.F_TELEPHONE_NUMBER, (Object)u.getTelephoneNumber(), (b, v) -> b.setTelephoneNumber((String)v)).nullSafeWithRetrieve((ItemPath)UserType.F_FULL_NAME, (Object)TypeConverter.toPolyStringMessage(u.getFullName()), (b, v) -> b.setFullName((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_GIVEN_NAME, (Object)TypeConverter.toPolyStringMessage(u.getGivenName()), (b, v) -> b.setGivenName((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_FAMILY_NAME, (Object)TypeConverter.toPolyStringMessage(u.getFamilyName()), (b, v) -> b.setFamilyName((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_ADDITIONAL_NAME, (Object)TypeConverter.toPolyStringMessage(u.getAdditionalName()), (b, v) -> b.setAdditionalName((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_NICK_NAME, (Object)TypeConverter.toPolyStringMessage(u.getNickName()), (b, v) -> b.setNickName((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_HONORIFIC_PREFIX, (Object)TypeConverter.toPolyStringMessage(u.getHonorificPrefix()), (b, v) -> b.setHonorificPrefix((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_HONORIFIC_SUFFIX, (Object)TypeConverter.toPolyStringMessage(u.getHonorificSuffix()), (b, v) -> b.setHonorificSuffix((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_TITLE, (Object)TypeConverter.toPolyStringMessage(u.getTitle()), (b, v) -> b.setTitle((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)UserType.F_EMPLOYEE_NUMBER, (Object)u.getEmployeeNumber(), (b, v) -> b.setEmployeeNumber((String)v)).nullSafeWithRetrieve((ItemPath)UserType.F_ORGANIZATION, TypeConverter.toPolyStringMessageList(u.getOrganization()), (b, v) -> b.addAllOrganization((Iterable<? extends PolyStringMessage>)v)).nullSafeWithRetrieve((ItemPath)UserType.F_ORGANIZATIONAL_UNIT, TypeConverter.toPolyStringMessageList(u.getOrganizationalUnit()), (b, v) -> b.addAllOrganizationalUnit((Iterable<? extends PolyStringMessage>)v)).nullSafeWithRetrieve((ItemPath)UserType.F_EXTENSION, (Object)u.getExtension(), (v, ops, hasInclude) -> TypeConverter.toItemMessageMap(v, ops, hasInclude), (b, v) -> b.putAllExtension((Map<String, ItemMessage>)v)).unwrap()).build();
    }

    public static RoleTypeMessage toRoleTypeMessage(RoleType u, Collection<SelectorOptions<GetOperationOptions>> options) {
        return ((RoleTypeMessage.Builder)BuilderWrapper.wrap((Object)RoleTypeMessage.newBuilder()).nullSafe((Object)u.getOid(), (b, v) -> b.setOid((String)v)).nullSafe((Object)u.getVersion(), (b, v) -> b.setVersion((String)v)).nullSafe((Object)TypeConverter.toPolyStringMessage(u.getName()), (b, v) -> b.setName((PolyStringMessage)v)).selectOptions(options).nullSafeWithRetrieve((ItemPath)RoleType.F_DESCRIPTION, (Object)u.getDescription(), (b, v) -> b.setDescription((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_SUBTYPE, (Object)u.getSubtype(), (b, v) -> b.addAllSubtype((Iterable<String>)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_LIFECYCLE_STATE, (Object)u.getLifecycleState(), (b, v) -> b.setLifecycleState((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_PARENT_ORG_REF, (Object)u.getParentOrgRef(), (b, v) -> b.addAllParentOrgRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)RoleType.F_ASSIGNMENT, (Object)u.getAssignment(), (b, v) -> b.addAllAssignment(v.stream().map(a -> AssignmentMessage.newBuilder().setTargetRef(TypeConverter.toReferenceMessage(a.getTargetRef(), null)).build()).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)RoleType.F_ARCHETYPE_REF, (Object)u.getArchetypeRef(), (b, v) -> b.addAllArchetypeRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)RoleType.F_ROLE_MEMBERSHIP_REF, (Object)u.getRoleMembershipRef(), (b, v) -> b.addAllRoleMembershipRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)RoleType.F_JPEG_PHOTO, (Object)TypeConverter.toBytesMessage(u.getJpegPhoto()), (b, v) -> b.setJpegPhoto((BytesMessage)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_COST_CENTER, (Object)u.getCostCenter(), (b, v) -> b.setCostCenter((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_LOCALITY, (Object)TypeConverter.toPolyStringMessage(u.getLocality()), (b, v) -> b.setLocality((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_PREFERRED_LANGUAGE, (Object)u.getPreferredLanguage(), (b, v) -> b.setPreferredLanguage((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_LOCALE, (Object)u.getLocale(), (b, v) -> b.setLocale((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_TIMEZONE, (Object)u.getTimezone(), (b, v) -> b.setTimezone((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_EMAIL_ADDRESS, (Object)u.getEmailAddress(), (b, v) -> b.setEmailAddress((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_TELEPHONE_NUMBER, (Object)u.getTelephoneNumber(), (b, v) -> b.setTelephoneNumber((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_DISPLAY_NAME, (Object)TypeConverter.toPolyStringMessage(u.getDisplayName()), (b, v) -> b.setDisplayName((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_IDENTIFIER, (Object)u.getIdentifier(), (b, v) -> b.setIdentifier((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_REQUESTABLE, (Object)u.isRequestable(), (b, v) -> b.setRequestable((boolean)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_DELEGABLE, (Object)u.isDelegable(), (b, v) -> b.setDelegable((boolean)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_RISK_LEVEL, (Object)u.getRiskLevel(), (b, v) -> b.setRiskLevel((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_ROLE_TYPE, (Object)u.getRoleType(), (b, v) -> b.setRoleType((String)v)).nullSafeWithRetrieve((ItemPath)RoleType.F_EXTENSION, (Object)u.getExtension(), (v, ops, hasInclude) -> TypeConverter.toItemMessageMap(v, ops, hasInclude), (b, v) -> b.putAllExtension((Map<String, ItemMessage>)v)).unwrap()).build();
    }

    public static OrgTypeMessage toOrgTypeMessage(OrgType u, Collection<SelectorOptions<GetOperationOptions>> options) {
        return ((OrgTypeMessage.Builder)BuilderWrapper.wrap((Object)OrgTypeMessage.newBuilder()).nullSafe((Object)u.getOid(), (b, v) -> b.setOid((String)v)).nullSafe((Object)u.getVersion(), (b, v) -> b.setVersion((String)v)).nullSafe((Object)TypeConverter.toPolyStringMessage(u.getName()), (b, v) -> b.setName((PolyStringMessage)v)).selectOptions(options).nullSafeWithRetrieve((ItemPath)OrgType.F_DESCRIPTION, (Object)u.getDescription(), (b, v) -> b.setDescription((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_SUBTYPE, (Object)u.getSubtype(), (b, v) -> b.addAllSubtype((Iterable<String>)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_LIFECYCLE_STATE, (Object)u.getLifecycleState(), (b, v) -> b.setLifecycleState((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_PARENT_ORG_REF, (Object)u.getParentOrgRef(), (b, v) -> b.addAllParentOrgRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)OrgType.F_ASSIGNMENT, (Object)u.getAssignment(), (b, v) -> b.addAllAssignment(v.stream().map(a -> AssignmentMessage.newBuilder().setTargetRef(TypeConverter.toReferenceMessage(a.getTargetRef(), null)).build()).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)OrgType.F_ARCHETYPE_REF, (Object)u.getArchetypeRef(), (b, v) -> b.addAllArchetypeRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)OrgType.F_ROLE_MEMBERSHIP_REF, (Object)u.getRoleMembershipRef(), (b, v) -> b.addAllRoleMembershipRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)OrgType.F_JPEG_PHOTO, (Object)TypeConverter.toBytesMessage(u.getJpegPhoto()), (b, v) -> b.setJpegPhoto((BytesMessage)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_COST_CENTER, (Object)u.getCostCenter(), (b, v) -> b.setCostCenter((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_LOCALITY, (Object)TypeConverter.toPolyStringMessage(u.getLocality()), (b, v) -> b.setLocality((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_PREFERRED_LANGUAGE, (Object)u.getPreferredLanguage(), (b, v) -> b.setPreferredLanguage((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_LOCALE, (Object)u.getLocale(), (b, v) -> b.setLocale((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_TIMEZONE, (Object)u.getTimezone(), (b, v) -> b.setTimezone((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_EMAIL_ADDRESS, (Object)u.getEmailAddress(), (b, v) -> b.setEmailAddress((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_TELEPHONE_NUMBER, (Object)u.getTelephoneNumber(), (b, v) -> b.setTelephoneNumber((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_DISPLAY_NAME, (Object)TypeConverter.toPolyStringMessage(u.getDisplayName()), (b, v) -> b.setDisplayName((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_IDENTIFIER, (Object)u.getIdentifier(), (b, v) -> b.setIdentifier((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_REQUESTABLE, (Object)u.isRequestable(), (b, v) -> b.setRequestable((boolean)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_DELEGABLE, (Object)u.isDelegable(), (b, v) -> b.setDelegable((boolean)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_RISK_LEVEL, (Object)u.getRiskLevel(), (b, v) -> b.setRiskLevel((String)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_ORG_TYPE, (Object)u.getOrgType(), (b, v) -> b.addAllOrgType((Iterable<String>)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_TENANT, (Object)u.isTenant(), (b, v) -> b.setTenant((boolean)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_MAIL_DOMAIN, (Object)u.getMailDomain(), (b, v) -> b.addAllMailDomain((Iterable<String>)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_DISPLAY_ORDER, (Object)u.getDisplayOrder(), (b, v) -> b.setDisplayOrder((int)v)).nullSafeWithRetrieve((ItemPath)OrgType.F_EXTENSION, (Object)u.getExtension(), (v, ops, hasInclude) -> TypeConverter.toItemMessageMap(v, ops, hasInclude), (b, v) -> b.putAllExtension((Map<String, ItemMessage>)v)).unwrap()).build();
    }

    public static ServiceTypeMessage toServiceTypeMessage(ServiceType u, Collection<SelectorOptions<GetOperationOptions>> options) {
        return ((ServiceTypeMessage.Builder)BuilderWrapper.wrap((Object)ServiceTypeMessage.newBuilder()).nullSafe((Object)u.getOid(), (b, v) -> b.setOid((String)v)).nullSafe((Object)u.getVersion(), (b, v) -> b.setVersion((String)v)).nullSafe((Object)TypeConverter.toPolyStringMessage(u.getName()), (b, v) -> b.setName((PolyStringMessage)v)).selectOptions(options).nullSafeWithRetrieve((ItemPath)ServiceType.F_DESCRIPTION, (Object)u.getDescription(), (b, v) -> b.setDescription((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_SUBTYPE, (Object)u.getSubtype(), (b, v) -> b.addAllSubtype((Iterable<String>)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_LIFECYCLE_STATE, (Object)u.getLifecycleState(), (b, v) -> b.setLifecycleState((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_PARENT_ORG_REF, (Object)u.getParentOrgRef(), (b, v) -> b.addAllParentOrgRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)ServiceType.F_ASSIGNMENT, (Object)u.getAssignment(), (b, v) -> b.addAllAssignment(v.stream().map(a -> AssignmentMessage.newBuilder().setTargetRef(TypeConverter.toReferenceMessage(a.getTargetRef(), null)).build()).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)ServiceType.F_ARCHETYPE_REF, (Object)u.getArchetypeRef(), (b, v) -> b.addAllArchetypeRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)ServiceType.F_ROLE_MEMBERSHIP_REF, (Object)u.getRoleMembershipRef(), (b, v) -> b.addAllRoleMembershipRef(v.stream().map(a -> TypeConverter.toReferenceMessage(a, null)).collect(Collectors.toList()))).nullSafeWithRetrieve((ItemPath)ServiceType.F_JPEG_PHOTO, (Object)TypeConverter.toBytesMessage(u.getJpegPhoto()), (b, v) -> b.setJpegPhoto((BytesMessage)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_COST_CENTER, (Object)u.getCostCenter(), (b, v) -> b.setCostCenter((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_LOCALITY, (Object)TypeConverter.toPolyStringMessage(u.getLocality()), (b, v) -> b.setLocality((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_PREFERRED_LANGUAGE, (Object)u.getPreferredLanguage(), (b, v) -> b.setPreferredLanguage((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_LOCALE, (Object)u.getLocale(), (b, v) -> b.setLocale((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_TIMEZONE, (Object)u.getTimezone(), (b, v) -> b.setTimezone((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_EMAIL_ADDRESS, (Object)u.getEmailAddress(), (b, v) -> b.setEmailAddress((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_TELEPHONE_NUMBER, (Object)u.getTelephoneNumber(), (b, v) -> b.setTelephoneNumber((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_DISPLAY_NAME, (Object)TypeConverter.toPolyStringMessage(u.getDisplayName()), (b, v) -> b.setDisplayName((PolyStringMessage)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_IDENTIFIER, (Object)u.getIdentifier(), (b, v) -> b.setIdentifier((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_REQUESTABLE, (Object)u.isRequestable(), (b, v) -> b.setRequestable((boolean)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_DELEGABLE, (Object)u.isDelegable(), (b, v) -> b.setDelegable((boolean)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_RISK_LEVEL, (Object)u.getRiskLevel(), (b, v) -> b.setRiskLevel((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_SERVICE_TYPE, (Object)u.getServiceType(), (b, v) -> b.addAllServiceType((Iterable<String>)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_DISPLAY_ORDER, (Object)u.getDisplayOrder(), (b, v) -> b.setDisplayOrder((int)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_URL, (Object)u.getUrl(), (b, v) -> b.setUrl((String)v)).nullSafeWithRetrieve((ItemPath)ServiceType.F_EXTENSION, (Object)u.getExtension(), (v, ops, hasInclude) -> TypeConverter.toItemMessageMap(v, ops, hasInclude), (b, v) -> b.putAllExtension((Map<String, ItemMessage>)v)).unwrap()).build();
    }

    public static Map<String, ItemMessage> toItemMessageMap(ExtensionType extension, Collection<SelectorOptions<GetOperationOptions>> options, boolean hasInclude) {
        if (extension == null) {
            return null;
        }
        LinkedHashMap<String, ItemMessage> map = new LinkedHashMap<String, ItemMessage>();
        PrismContainerValue extensionValue = extension.asPrismContainerValue();
        for (Item item : extensionValue.getItems()) {
            ItemDefinition definition = item.getDefinition();
            if (definition == null) {
                LOGGER.warn("No schema for the extension value: {}", (Object)item);
                continue;
            }
            String key = definition.getItemName().getLocalPart();
            if (!SelectorOptions.hasToLoadPath((ItemPath)item.getPath(), options, (!hasInclude ? 1 : 0) != 0)) continue;
            try {
                map.put(key, TypeConverter.toItemMessage(definition, item));
            }
            catch (SchemaException e) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_schema: " + e.getMessage()).withCause((Throwable)e).asRuntimeException();
                throw exception;
            }
        }
        return map;
    }

    private static PrismContainerValueMessage toPrismContainerValueMessage(PrismContainerDefinition definition, PrismContainerValue<?> value, Collection<SelectorOptions<GetOperationOptions>> options, boolean hasInclude) throws SchemaException {
        PrismContainerValueMessage.Builder builder = PrismContainerValueMessage.newBuilder();
        if (value.getId() != null) {
            builder.setId(value.getId());
        }
        for (Item item : value.getItems()) {
            if (!SelectorOptions.hasToLoadPath((ItemPath)item.getPath(), options, (!hasInclude ? 1 : 0) != 0)) continue;
            ItemDefinition itemDefinition = item.getDefinition();
            String key = itemDefinition.getItemName().getLocalPart();
            builder.putValue(key, TypeConverter.toItemMessage(itemDefinition, item, options, hasInclude));
        }
        return builder.build();
    }

    public static PrismObjectMessage toPrismObjectMessage(ItemDefinition definition, PrismObject<? extends ObjectType> prismObject) throws SchemaException {
        return TypeConverter.toPrismObjectMessage(definition, prismObject, null, false);
    }

    public static PrismObjectMessage toPrismObjectMessage(ItemDefinition definition, PrismObject<? extends ObjectType> prismObject, Collection<SelectorOptions<GetOperationOptions>> options, boolean hasInclude) throws SchemaException {
        if (definition.isSingleValue() && prismObject.size() > 1) {
            throw new SchemaException("It must be single value: " + definition);
        }
        PrismObjectMessage.Builder builder = PrismObjectMessage.newBuilder().setOid(prismObject.getOid());
        for (Item item : prismObject.getValue().getItems()) {
            if (!SelectorOptions.hasToLoadPath((ItemPath)item.getPath(), options, (!hasInclude ? 1 : 0) != 0)) continue;
            builder.putValue(item.getElementName().getLocalPart(), TypeConverter.toItemMessage(item.getDefinition(), item, options, hasInclude));
        }
        return builder.build();
    }

    public static ItemMessage toItemMessage(ItemDefinition definition, Item<?, ?> item) throws SchemaException {
        return TypeConverter.toItemMessage(definition, item, null, false);
    }

    public static ItemMessage toItemMessage(ItemDefinition definition, Item<?, ?> item, Collection<SelectorOptions<GetOperationOptions>> options, boolean hasInclude) throws SchemaException {
        if (definition.isSingleValue() && item.size() > 1) {
            throw new SchemaException("It must be single value: " + definition);
        }
        ItemMessage.Builder builder = ItemMessage.newBuilder().setMultiple(definition.isMultiValue());
        if (definition instanceof PrismPropertyDefinition) {
            return builder.setProperty(TypeConverter.toPrismPropertyMessage((PrismPropertyDefinition)definition, (PrismProperty)item)).build();
        }
        if (definition instanceof PrismContainerDefinition) {
            return builder.setContainer(TypeConverter.toPrismContainerMessage((PrismContainerDefinition)definition, (PrismContainer)item, options, hasInclude)).build();
        }
        if (definition instanceof PrismReferenceDefinition) {
            return builder.setRef(TypeConverter.toPrismReferenceMessage((PrismReferenceDefinition)definition, (PrismReference)item)).build();
        }
        throw new SchemaException(definition.getClass() + " is not supported");
    }

    private static PrismPropertyMessage toPrismPropertyMessage(PrismPropertyDefinition<?> definition, PrismProperty<?> value) {
        if (definition.isSingleValue()) {
            return PrismPropertyMessage.newBuilder().addValues(TypeConverter.toPrismPropertyValueMessage(definition, value.getValue())).build();
        }
        PrismPropertyMessage.Builder builder = PrismPropertyMessage.newBuilder();
        for (PrismPropertyValue v : value.getValues()) {
            builder.addValues(TypeConverter.toPrismPropertyValueMessage(definition, v));
        }
        return builder.build();
    }

    private static PrismContainerMessage toPrismContainerMessage(PrismContainerDefinition definition, PrismContainer value, Collection<SelectorOptions<GetOperationOptions>> options, boolean hasInclude) throws SchemaException {
        if (definition.isSingleValue()) {
            return PrismContainerMessage.newBuilder().addValues(TypeConverter.toPrismContainerValueMessage(definition, value.getValue(), options, hasInclude)).build();
        }
        PrismContainerMessage.Builder builder = PrismContainerMessage.newBuilder();
        for (Object v : value.getValues()) {
            builder.addValues(TypeConverter.toPrismContainerValueMessage(definition, (PrismContainerValue)v, options, hasInclude));
        }
        return builder.build();
    }

    private static PrismReferenceMessage toPrismReferenceMessage(PrismReferenceDefinition definition, PrismReference value) {
        if (definition.isSingleValue()) {
            return PrismReferenceMessage.newBuilder().addValues(TypeConverter.toReferenceMessage((ItemDefinition)definition, (PrismReferenceValue)value.getValue())).build();
        }
        PrismReferenceMessage.Builder builder = PrismReferenceMessage.newBuilder();
        for (PrismReferenceValue v : value.getValues()) {
            ReferenceMessage message = TypeConverter.toReferenceMessage((ItemDefinition)definition, v);
            if (message == null) continue;
            builder.addValues(message);
        }
        return builder.build();
    }

    private static PrismPropertyValueMessage toPrismPropertyValueMessage(PrismPropertyDefinition definition, PrismPropertyValue<?> value) {
        PrismPropertyValueMessage.Builder builder = PrismPropertyValueMessage.newBuilder();
        if (definition.getTypeClass() == String.class) {
            builder.setString((String)value.getValue());
        } else if (definition.getTypeClass() == PolyString.class) {
            builder.setPolyString(TypeConverter.toPolyStringMessage((PolyString)value.getValue()));
        } else if (definition.getTypeClass() == Integer.TYPE) {
            builder.setInteger(TypeConverter.toIntegerMessage((Integer)value.getValue()));
        } else if (definition.getTypeClass() == Long.TYPE) {
            builder.setLong(TypeConverter.toLongMessage((Long)value.getValue()));
        } else if (definition.getTypeName().equals(ProtectedStringType.COMPLEX_TYPE)) {
            Protector protector = definition.getPrismContext().getDefaultProtector();
            ProtectedStringType p = (ProtectedStringType)value.getValue();
            try {
                builder.setString(protector.decryptString((ProtectedData)p));
            }
            catch (EncryptionException e) {
                StatusRuntimeException exception = Status.INTERNAL.withDescription("invalid_schema: Can't decrypt " + definition.getItemName()).asRuntimeException();
                throw exception;
            }
        } else {
            builder.setString(value.getRealValue().toString());
        }
        return builder.build();
    }

    public static ItemPath toItemPathValue(ItemPathMessage itemPath) {
        List qnames = itemPath.getPathList().stream().map(x -> TypeConverter.toQNameValue(x)).collect(Collectors.toList());
        return ItemPath.create(qnames);
    }

    public static List<PrismValue> toPrismValueList(PrismContext prismContext, ItemDefinition definition, List<PrismValueMessage> prismValue) throws SchemaException {
        ArrayList<PrismValue> values = new ArrayList<PrismValue>();
        for (PrismValueMessage pvm : prismValue) {
            values.add(TypeConverter.toPrismValue(prismContext, definition, pvm));
        }
        return values;
    }

    private static PrismValue toPrismValue(PrismContext prismContext, ItemDefinition definition, PrismValueMessage prismValueMessage) throws SchemaException {
        if (prismValueMessage.hasContainer()) {
            if (!(definition instanceof PrismContainerDefinition)) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_prism_container_schema").asRuntimeException();
                throw exception;
            }
            return TypeConverter.toPrismContainerValue(prismContext, (PrismContainerDefinition)definition, prismValueMessage.getContainer());
        }
        if (prismValueMessage.hasProperty()) {
            if (!(definition instanceof PrismPropertyDefinition)) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_prism_property_schema").asRuntimeException();
                throw exception;
            }
            return TypeConverter.toPrismPropertyValue(prismContext, (PrismPropertyDefinition)definition, prismValueMessage.getProperty());
        }
        if (!(definition instanceof PrismReferenceDefinition)) {
            StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_prism_reference_schema").asRuntimeException();
            throw exception;
        }
        return TypeConverter.toPrismReferenceValue(prismContext, (PrismReferenceDefinition)definition, prismValueMessage.getRef());
    }

    private static PrismContainer toPrismContainer(PrismContext prismContext, PrismContainerDefinition definition, PrismContainerMessage container) throws SchemaException {
        PrismContainer pc = prismContext.itemFactory().createContainer((QName)definition.getItemName(), definition);
        for (PrismContainerValueMessage pcvm : container.getValuesList()) {
            pc.add((PrismValue)TypeConverter.toPrismContainerValue(prismContext, definition, pcvm));
        }
        return pc;
    }

    private static PrismContainerValue toPrismContainerValue(PrismContext prismContext, PrismContainerDefinition definition, PrismContainerValueMessage message) throws SchemaException {
        PrismContainerValue impl = prismContext.itemFactory().createContainerValue();
        impl.applyDefinition((ItemDefinition)definition);
        for (Map.Entry<String, ItemMessage> entry : message.getValueMap().entrySet()) {
            String k = entry.getKey();
            ItemMessage v = entry.getValue();
            QName qname = TypeConverter.toQName(v, k);
            ItemPath path = ItemPath.create((Object[])new Object[]{qname});
            ItemDefinition itemDefinition = definition.findItemDefinition(path);
            if (itemDefinition == null) {
                throw new SchemaException("No schema: " + qname);
            }
            if (itemDefinition instanceof PrismPropertyDefinition) {
                impl.add(TypeConverter.toPrismProperty(prismContext, (PrismPropertyDefinition)itemDefinition, v.getProperty()));
                continue;
            }
            if (itemDefinition instanceof PrismContainerDefinition) {
                impl.add((Item)TypeConverter.toPrismContainer(prismContext, (PrismContainerDefinition)itemDefinition, v.getContainer()));
                continue;
            }
            if (itemDefinition instanceof PrismReferenceDefinition) {
                impl.add(TypeConverter.toPrismReference(prismContext, (PrismReferenceDefinition)itemDefinition, v.getRef()));
                continue;
            }
            throw new UnsupportedOperationException(itemDefinition.getClass() + " is not supported");
        }
        return impl;
    }

    private static PrismObjectValue toPrismObjectValue(PrismContext prismContext, PrismContainerDefinition definition, PrismContainerValueMessage message, Objectable objectable) throws SchemaException {
        PrismObjectValue impl = prismContext.itemFactory().createObjectValue(objectable);
        impl.applyDefinition((ItemDefinition)definition);
        for (Map.Entry<String, ItemMessage> entry : message.getValueMap().entrySet()) {
            String k = entry.getKey();
            ItemMessage v = entry.getValue();
            QName qname = TypeConverter.toQName(v, k);
            ItemPath path = ItemPath.create((Object[])new Object[]{qname});
            ItemDefinition itemDefinition = definition.findItemDefinition(path);
            if (itemDefinition == null) {
                throw new SchemaException("No schema: " + qname);
            }
            if (itemDefinition instanceof PrismPropertyDefinition) {
                impl.add(TypeConverter.toPrismProperty(prismContext, (PrismPropertyDefinition)itemDefinition, v.getProperty()));
                continue;
            }
            if (itemDefinition instanceof PrismContainerDefinition) {
                impl.add((Item)TypeConverter.toPrismContainer(prismContext, (PrismContainerDefinition)itemDefinition, v.getContainer()));
                continue;
            }
            if (itemDefinition instanceof PrismReferenceDefinition) {
                impl.add(TypeConverter.toPrismReference(prismContext, (PrismReferenceDefinition)itemDefinition, v.getRef()));
                continue;
            }
            throw new UnsupportedOperationException(itemDefinition.getClass() + " is not supported");
        }
        return impl;
    }

    private static Item toPrismReference(PrismContext prismContext, PrismReferenceDefinition definition, PrismReferenceMessage ref) throws SchemaException {
        PrismReference pp = prismContext.itemFactory().createReference((QName)definition.getItemName(), definition);
        for (ReferenceMessage value : ref.getValuesList()) {
            pp.add((PrismValue)TypeConverter.toPrismReferenceValue(prismContext, definition, value));
        }
        return pp;
    }

    private static Item toPrismProperty(PrismContext prismContext, PrismPropertyDefinition definition, PrismPropertyMessage property) {
        PrismProperty pp = prismContext.itemFactory().createProperty((QName)definition.getItemName(), definition);
        for (PrismPropertyValueMessage ppvm : property.getValuesList()) {
            pp.addValue(TypeConverter.toPrismPropertyValue(prismContext, definition, ppvm));
        }
        return pp;
    }

    private static PrismPropertyValue toPrismPropertyValue(PrismContext prismContext, PrismPropertyDefinition definition, PrismPropertyValueMessage property) {
        return new PrismPropertyValueImpl(TypeConverter.toRealValue(prismContext, definition, property));
    }

    private static Object toRealValue(PrismContext prismContext, PrismPropertyDefinition definition, PrismPropertyValueMessage message) {
        if (message.hasInteger()) {
            return TypeConverter.toIntegerValue(message.getInteger());
        }
        if (message.hasLong()) {
            return TypeConverter.toLongValue(message.getLong());
        }
        if (message.hasPolyString()) {
            return TypeConverter.toPolyString(message.getPolyString());
        }
        String s = message.getString();
        if (definition.getTypeName().equals(ProtectedStringType.COMPLEX_TYPE)) {
            ProtectedStringType p = new ProtectedStringType();
            p.setClearValue((Object)s);
            return p;
        }
        return s;
    }

    private static PolyString toPolyString(PolyStringMessage message) {
        if (TypeConverter.isEmpty(message)) {
            return null;
        }
        return new PolyString(message.getOrig(), message.getNorm());
    }

    private static PrismReferenceValue toPrismReferenceValue(PrismContext prismContext, PrismReferenceDefinition definition, ReferenceMessage ref) throws SchemaException {
        return TypeConverter.toObjectReferenceTypeValue(prismContext, ref).asReferenceValue();
    }

    static {
        HashMap strToItemName = new HashMap();
        Field[] fields = UserType.class.getFields();
        Arrays.stream(fields).filter(x -> x.getName().startsWith("F_") && x.getType() == ItemName.class).forEach(x -> {
            String name = x.getName();
            try {
                DefaultUserTypePath path = DefaultUserTypePath.valueOf(name);
                ItemName itemName = (ItemName)x.get(null);
                userTypeMap.put(path, itemName);
                strToItemName.put(itemName.getLocalPart(), itemName);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }
}

