/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.junit.result;

import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import jp.vmi.junit.result.ITestCase;
import jp.vmi.junit.result.ITestSuite;
import jp.vmi.junit.result.ObjectFactory;
import jp.vmi.junit.result.TestCaseResult;
import jp.vmi.junit.result.TestResult;
import jp.vmi.junit.result.TestSuiteResult;
import org.apache.commons.lang.time.FastDateFormat;
import org.jboss.netty.util.internal.ConcurrentIdentityHashMap;

public final class JUnitResult {
    private static final FastDateFormat DATE_TIME_FORMAT = FastDateFormat.getInstance((String)"[yyyy-MM-dd HH:mm:ss.SSS] ");
    private static JAXBContext context = JUnitResult.initContext();
    private static final Map<Object, TestResult> map = new ConcurrentIdentityHashMap();
    private static String resultDir = null;
    private static PrintStream ps = null;

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setResultDir(String dir) {
        resultDir = dir;
    }

    public static void setPrintStream(PrintStream ps) {
        JUnitResult.ps = ps;
    }

    public static void startTestSuite(ITestSuite testSuite) {
        map.put(testSuite, ObjectFactory.factory.createTestSuiteResult(testSuite.getName()));
    }

    public static void endTestSuite(ITestSuite testSuite) {
        TestSuiteResult suiteResult = (TestSuiteResult)map.remove(testSuite);
        suiteResult.endTestSuite();
        if (resultDir == null) {
            return;
        }
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            File file = new File(resultDir, "TEST-" + suiteResult.getName() + ".xml");
            marshaller.marshal((Object)suiteResult, file);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addProperty(ITestSuite testSuite, String name, String value) {
        TestSuiteResult suiteResult = (TestSuiteResult)map.get(testSuite);
        suiteResult.addProperty(name, value);
    }

    public static void startTestCase(ITestSuite testSuite, ITestCase testCase) {
        TestCaseResult caseResult = ObjectFactory.factory.createTestCaseResult(testCase.getName());
        map.put(testCase, caseResult);
        if (testSuite != null) {
            TestSuiteResult suiteResult = (TestSuiteResult)map.get(testSuite);
            suiteResult.addTestCaseResult(caseResult);
        }
    }

    public static void endTestCase(ITestCase testCase) {
        TestCaseResult caseResult = (TestCaseResult)map.remove(testCase);
        caseResult.endTestCase();
    }

    public static void setSuccess(ITestCase testCase) {
        TestCaseResult caseResult = (TestCaseResult)map.get(testCase);
        caseResult.setSuccess();
    }

    public static void setError(ITestCase testCase, String message, String trace) {
        TestCaseResult caseResult = (TestCaseResult)map.get(testCase);
        caseResult.setError(message, trace);
    }

    public static void setFailure(ITestCase testCase, String message, String trace) {
        TestCaseResult caseResult = (TestCaseResult)map.get(testCase);
        caseResult.setFailure(message, trace);
    }

    public static void addSystemOut(ITestCase testCase, String message) {
        TestCaseResult caseResult = (TestCaseResult)map.get(testCase);
        caseResult.addSystemOut(message);
    }

    public static void addSystemErr(ITestCase testCase, String message) {
        TestCaseResult caseResult = (TestCaseResult)map.get(testCase);
        caseResult.addSystemErr(message);
    }

    private static String logFormat(String level, String ... messages) {
        StringBuilder logMsg = new StringBuilder(DATE_TIME_FORMAT.format(System.currentTimeMillis()));
        logMsg.append(level);
        for (String message : messages) {
            logMsg.append(" ").append(message);
        }
        return logMsg.toString();
    }

    public static void logInfo(ITestCase testCase, String ... messages) {
        String msg = JUnitResult.logFormat("[INFO]", messages);
        if (testCase != null) {
            TestCaseResult caseResult = (TestCaseResult)map.get(testCase);
            caseResult.addSystemOut(msg);
        }
        if (ps != null) {
            ps.println(msg);
        }
    }

    public static void logError(ITestCase testCase, String ... messages) {
        String msg = JUnitResult.logFormat("[ERROR]", messages);
        if (testCase != null) {
            TestCaseResult caseResult = (TestCaseResult)map.get(testCase);
            caseResult.addSystemErr(msg);
        }
        if (ps != null) {
            ps.println(msg);
        }
    }
}

