/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.junit.result;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jp.vmi.junit.result.Error;
import jp.vmi.junit.result.Failure;
import jp.vmi.junit.result.ObjectFactory;
import jp.vmi.junit.result.SkippedAdapter;
import jp.vmi.junit.result.TestResult;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"skipped", "error", "failure", "systemOut", "systemErr"})
public class TestCaseResult
extends TestResult {
    private static final String NL = System.getProperty("line.separator");
    @XmlTransient
    private final List<String> systemOuts = new ArrayList<String>();
    @XmlTransient
    private final List<String> systemErrs = new ArrayList<String>();
    @XmlTransient
    private boolean success = false;
    @XmlElement
    private Error error = null;
    @XmlElement
    private Failure failure = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemOut(String message) {
        List<String> list = this.systemOuts;
        synchronized (list) {
            this.systemOuts.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemErr(String message) {
        List<String> list = this.systemErrs;
        synchronized (list) {
            this.systemErrs.add(message);
        }
    }

    public void setSuccess() {
        this.success = true;
    }

    public void setError(String message, String value) {
        this.error = ObjectFactory.factory.createError(message, value);
    }

    public void setFailure(String message, String value) {
        this.failure = ObjectFactory.factory.createFailure(message, value);
    }

    public void endTestCase() {
        this.endTest();
    }

    public int getErrors() {
        return this.error != null ? 1 : 0;
    }

    public int getFailures() {
        return this.failure != null ? 1 : 0;
    }

    @XmlElementRef
    @XmlJavaTypeAdapter(value=SkippedAdapter.class)
    public Integer getSkipped() {
        return !this.success && this.error == null && this.failure == null ? 1 : 0;
    }

    @XmlElement(name="system-out")
    public String getSystemOut() {
        return this.systemOuts.size() != 0 ? StringUtils.join(this.systemOuts, (String)NL) : null;
    }

    @XmlElement(name="system-err")
    public String getSystemErr() {
        return this.systemErrs.size() != 0 ? StringUtils.join(this.systemErrs, (String)NL) : null;
    }
}

