/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.junit.result;

import javax.xml.bind.annotation.XmlAttribute;
import org.apache.commons.lang.time.DateFormatUtils;

public abstract class TestResult {
    private String name;
    private long startTimeOfUTC;
    private long startTime;
    private long endTime;

    protected TestResult() {
        this.startTest();
    }

    private void startTest() {
        this.endTime = this.startTime = System.nanoTime();
        this.startTimeOfUTC = System.currentTimeMillis();
    }

    protected void endTest() {
        this.endTime = System.nanoTime();
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlAttribute
    public String getTimestamp() {
        return DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(this.startTimeOfUTC);
    }

    @XmlAttribute
    public String getTime() {
        return String.format("%.3f", (double)(this.endTime - this.startTime) / 1.0E9);
    }
}

