/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jp.vmi.selenium.selenese.ErrorTestCase;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.TestCaseParser;
import jp.vmi.selenium.selenese.TestSuiteParser;
import jp.vmi.selenium.selenese.inject.Binder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xpath.XPathAPI;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class Parser {
    protected final File file;
    protected final Document docucment;

    protected static Iterable<Node> each(final NodeList nodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new NodeIterator(nodeList);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Selenese parse(File file, Runner runner) {
        Parser p;
        String name = FilenameUtils.getBaseName((String)file.getName());
        FileInputStream is = null;
        try {
            DOMParser dp = new DOMParser();
            dp.setEntityResolver(null);
            dp.setFeature("http://xml.org/sax/features/namespaces", false);
            dp.setFeature("http://apache.org/xml/features/include-comments", true);
            is = new FileInputStream(file);
            dp.parse(new InputSource(is));
            Document document = dp.getDocument();
            try {
                String baseURL = XPathAPI.selectSingleNode((Node)document, (String)"/HTML/HEAD/LINK[@rel='selenium.base']/@href").getNodeValue();
                p = new TestCaseParser(file, document, baseURL);
            }
            catch (NullPointerException e) {
                try {
                    XPathAPI.selectSingleNode((Node)document, (String)"/HTML/BODY/TABLE[@id='suiteTable']");
                    p = new TestSuiteParser(file, document);
                }
                catch (NullPointerException e2) {
                    ErrorTestCase errorTestCase = Binder.newErrorTestCase(name, new InvalidSeleneseException("Not selenese script. Missing neither 'selenium.base' link nor table with 'suiteTable' id"));
                    IOUtils.closeQuietly((InputStream)is);
                    return errorTestCase;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (FileNotFoundException e) {
            ErrorTestCase errorTestCase = Binder.newErrorTestCase(name, new InvalidSeleneseException(e.getMessage()));
            return errorTestCase;
        }
        catch (Exception e2) {
            ErrorTestCase errorTestCase = Binder.newErrorTestCase(name, new InvalidSeleneseException(e2));
            return errorTestCase;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return p.parse(runner);
    }

    protected Parser(File file, Document document) {
        this.file = file;
        this.docucment = document;
    }

    protected abstract Selenese parse(Runner var1);

    protected static class NodeIterator
    implements Iterator<Node> {
        private final NodeList nodeList;
        private int index = 0;

        protected NodeIterator(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.nodeList.getLength();
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nodeList.item(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

