/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import jp.vmi.junit.result.JUnitResult;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.TestSuite;
import jp.vmi.selenium.selenese.inject.Binder;
import jp.vmi.selenium.selenese.result.Result;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runner {
    private static final Logger log = LoggerFactory.getLogger(Runner.class);
    private static final FastDateFormat FILE_DATE_TIME = FastDateFormat.getInstance((String)"yyyyMMdd_HHmmssSSS");
    private WebDriver driver;
    private String screenshotDir = null;
    private String screenshotAllDir = null;
    private String screenshotOnFailDir = null;
    private String baseURL = "";
    private int timeout = 30000;
    private final int countForDefault = 0;

    private void takeScreenshot(File file, TestCase testcase) {
        File tmp = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
        try {
            FileUtils.moveFile((File)tmp, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to rename captured screenshot image: " + file, e);
        }
        log.info("- captured screenshot: {}", (Object)file);
        JUnitResult.addSystemOut(testcase, "[[ATTACHMENT|" + file.getAbsolutePath() + "]]");
    }

    public void takeScreenshot(String filename, TestCase testcase) throws UnsupportedOperationException {
        if (!(this.driver instanceof TakesScreenshot)) {
            throw new UnsupportedOperationException("webdriver does not support capturing screenshot.");
        }
        File file = new File(filename).getAbsoluteFile();
        if (this.screenshotDir != null) {
            file = new File(this.screenshotDir, file.getName()).getAbsoluteFile();
        }
        this.takeScreenshot(file, testcase);
    }

    public void takeScreenshotAll(String prefix, int index, TestCase testcase) {
        if (this.screenshotAllDir == null || !(this.driver instanceof TakesScreenshot)) {
            return;
        }
        String filename = String.format("%s_%s_%d.png", prefix, FILE_DATE_TIME.format(Calendar.getInstance()), index);
        this.takeScreenshot(new File(this.screenshotAllDir, filename), testcase);
    }

    public void takeScreenshotOnFail(String prefix, int index, TestCase testcase) {
        if (this.screenshotOnFailDir == null || !(this.driver instanceof TakesScreenshot)) {
            return;
        }
        String filename = String.format("%s_%s_%d_fail.png", prefix, FILE_DATE_TIME.format(Calendar.getInstance()), index);
        this.takeScreenshot(new File(this.screenshotOnFailDir, filename), testcase);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public void setScreenshotDir(String screenshotDir) throws IllegalArgumentException {
        if (screenshotDir != null && !new File(screenshotDir).isDirectory()) {
            throw new IllegalArgumentException(screenshotDir + " is not directory.");
        }
        this.screenshotDir = screenshotDir;
    }

    public void setScreenshotAllDir(String screenshotAllDir) throws IllegalArgumentException {
        if (screenshotAllDir != null && !new File(screenshotAllDir).isDirectory()) {
            throw new IllegalArgumentException(screenshotAllDir + " is not directory.");
        }
        this.screenshotAllDir = screenshotAllDir;
    }

    public void setScreenshotOnFailDir(String screenshotOnFailDir) {
        if (screenshotOnFailDir != null && !new File(screenshotOnFailDir).isDirectory()) {
            throw new IllegalArgumentException(screenshotOnFailDir + " is not directory.");
        }
        this.screenshotOnFailDir = screenshotOnFailDir;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getEffectiveBaseURL(String baseURL) {
        if (StringUtils.isBlank((String)this.baseURL)) {
            return baseURL;
        }
        return this.baseURL;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Result run(String ... filenames) {
        TestSuite testSuite = Binder.newTestSuite(null, String.format("default-%02d", 0), this);
        for (String filename : filenames) {
            testSuite.addTestCase(filename);
        }
        return testSuite.execute(null);
    }

    public void setResultDir(String dir) {
        JUnitResult.setResultDir(dir);
    }

    public void setPrintStream(PrintStream out) {
        JUnitResult.setPrintStream(out);
    }
}

