/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import jp.vmi.junit.result.ITestCase;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.cmdproc.CustomCommandProcessor;
import jp.vmi.selenium.selenese.command.Command;
import jp.vmi.selenium.selenese.command.CommandList;
import jp.vmi.selenium.selenese.command.Label;
import jp.vmi.selenium.selenese.inject.DoCommand;
import jp.vmi.selenium.selenese.inject.ExecuteTestCase;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.apache.commons.io.FilenameUtils;

public class TestCase
implements Selenese,
ITestCase {
    private File file = null;
    private String basename = null;
    private String name = null;
    private Runner runner = null;
    private String baseURL = null;
    private long speed = 0L;
    private CustomCommandProcessor proc = null;
    private final Map<String, Deque<String>> collectionMap = new HashMap<String, Deque<String>>();
    private final Map<String, Label> labelCommandMap = new HashMap<String, Label>();
    private final CommandList commandList = new CommandList();
    private Command prev = this.commandList;

    public TestCase initialize(File file, String name, Runner runner, String baseURL) {
        this.file = file;
        this.basename = file != null ? FilenameUtils.getBaseName((String)file.getName()) : "nofile";
        this.name = name;
        this.runner = runner;
        this.baseURL = baseURL.replaceFirst("/+$", "");
        this.proc = new CustomCommandProcessor(baseURL, runner.getDriver());
        return this;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Runner getRunner() {
        return this.runner;
    }

    public CustomCommandProcessor getProc() {
        return this.proc;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }

    public long getSpeed() {
        return this.speed;
    }

    public boolean isTrue(String expr) {
        return Boolean.parseBoolean(this.proc.doCommand("getEval", new String[]{expr}));
    }

    public void addCollection(String collectionName) {
        this.collectionMap.put(collectionName, new ArrayDeque());
    }

    public void addToCollection(String collectionName, String value) {
        Deque<String> collection = this.collectionMap.get(collectionName);
        collection.addLast(value);
    }

    public String pollFromCollection(String collectionName) {
        Deque<String> collection = this.collectionMap.get(collectionName);
        return collection.pollFirst();
    }

    public void setLabelCommand(Label labelCommand) {
        this.labelCommandMap.put(labelCommand.getLabel(), labelCommand);
    }

    public Label getLabelCommand(String label) {
        return this.labelCommandMap.get(label);
    }

    public void addCommand(Command command) {
        this.prev = this.prev.setNext(command);
    }

    @DoCommand
    protected Result doCommand(Command command) {
        return command.doCommand(this);
    }

    @Override
    @ExecuteTestCase
    public Result execute(Selenese parent) {
        Command current = this.commandList.first();
        Result totalResult = Success.SUCCESS;
        while (current != null) {
            Result result = this.doCommand(current);
            if (current.canUpdate()) {
                this.runner.takeScreenshotAll(this.basename, current.getIndex(), this);
                if (!result.isSuccess()) {
                    this.runner.takeScreenshotOnFail(this.basename, current.getIndex(), this);
                }
            }
            if ((totalResult = totalResult.update(result)).isAborted()) break;
            current = current.next(this);
            if (this.speed <= 0L) continue;
            try {
                Thread.sleep(this.speed);
            }
            catch (InterruptedException e) {}
        }
        return totalResult;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("TestCase[").append(this.name).append("]");
        if (this.file != null) {
            s.append(" (").append(this.file).append(")");
        }
        return s.toString();
    }
}

