/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Parser;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.command.Command;
import jp.vmi.selenium.selenese.command.CommandFactory;
import jp.vmi.selenium.selenese.command.EndLoop;
import jp.vmi.selenium.selenese.command.Label;
import jp.vmi.selenium.selenese.command.StartLoop;
import jp.vmi.selenium.selenese.inject.Binder;
import org.apache.commons.io.FilenameUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestCaseParser
extends Parser {
    private final String baseURL;

    protected TestCaseParser(File file, Document document, String baseURL) throws InvalidSeleneseException {
        super(file, document);
        this.baseURL = baseURL;
    }

    @Override
    public Selenese parse(Runner runner) {
        String name = null;
        try {
            String baseURL = runner.getEffectiveBaseURL(this.baseURL);
            name = XPathAPI.selectSingleNode((Node)this.docucment, (String)"//THEAD/TR/TD").getTextContent();
            TestCase testCase = Binder.newTestCase(this.file, name, runner, baseURL);
            CommandFactory commandFactory = new CommandFactory(testCase.getProc());
            Node tbody = XPathAPI.selectSingleNode((Node)this.docucment, (String)"//TBODY");
            NodeList trList = tbody.getChildNodes();
            ArrayDeque<StartLoop> loopCommandStack = new ArrayDeque<StartLoop>();
            int tri = 0;
            block6: for (Node tr : TestCaseParser.each(trList)) {
                ArrayList<String> cmdWithArgs;
                switch (tr.getNodeType()) {
                    case 1: {
                        ++tri;
                        cmdWithArgs = new ArrayList(3);
                        for (Node td : TestCaseParser.each(tr.getChildNodes())) {
                            if (!"TD".equals(td.getNodeName())) continue;
                            String value = td.getTextContent();
                            cmdWithArgs.add(value);
                        }
                        break;
                    }
                    case 8: {
                        cmdWithArgs = new ArrayList<String>(2);
                        cmdWithArgs.add("comment");
                        cmdWithArgs.add(tr.getNodeValue().trim());
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                Command command = commandFactory.newCommand(tri, cmdWithArgs);
                if (command instanceof Label) {
                    testCase.setLabelCommand((Label)command);
                } else if (command instanceof StartLoop) {
                    loopCommandStack.push((StartLoop)((Object)command));
                } else if (command instanceof EndLoop) {
                    StartLoop startLoop = (StartLoop)loopCommandStack.pop();
                    startLoop.setEndLoop((EndLoop)((Object)command));
                    ((EndLoop)((Object)command)).setStartLoop(startLoop);
                }
                testCase.addCommand(command);
            }
            return testCase;
        }
        catch (TransformerException e) {
            if (name == null) {
                name = FilenameUtils.getBaseName((String)this.file.getName());
            }
            return Binder.newErrorTestCase(name, new InvalidSeleneseException(e));
        }
    }
}

