/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.vmi.junit.result.ITestSuite;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Parser;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.inject.ExecuteTestSuite;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuite
implements Selenese,
ITestSuite {
    private static final Logger log = LoggerFactory.getLogger(TestSuite.class);
    private File file;
    private String parentDir = null;
    private String name;
    private Runner runner;
    private final List<File> files = new ArrayList<File>();

    public TestSuite initialize(File file, String name, Runner runner) {
        try {
            this.file = file;
            if (file != null) {
                this.parentDir = file.getCanonicalFile().getParent();
            }
            if (name != null) {
                this.name = name;
            } else if (file != null) {
                this.name = FilenameUtils.getBaseName((String)file.getName());
            }
            this.runner = runner;
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Runner getRunner() {
        return this.runner;
    }

    public void addTestCase(String filename) {
        File tcFile = new File(filename);
        if (!tcFile.isAbsolute()) {
            tcFile = new File(this.parentDir, filename);
        }
        this.files.add(tcFile);
    }

    @Override
    @ExecuteTestSuite
    public Result execute(Selenese parent) {
        Result totalResult = Success.SUCCESS;
        for (File file : this.files) {
            Result result;
            Selenese selenese = Parser.parse(file, this.runner);
            try {
                result = selenese.execute(this);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage());
                throw e;
            }
            catch (InvalidSeleneseException e) {
                result = new Error(e);
            }
            totalResult = totalResult.update(result);
        }
        return totalResult;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("TestSuite[").append(this.name).append("]");
        if (this.file != null) {
            s.append(" (").append(this.file).append(")");
        }
        return s.toString();
    }
}

