/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.thoughtworks.selenium.SeleniumException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.cmdproc.CustomCommandProcessor;
import jp.vmi.selenium.selenese.command.Command;
import jp.vmi.selenium.selenese.result.Failure;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.result.Warning;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assertion
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Assertion.class);
    private static final int RETRY_INTERVAL = 100;
    private final Type type;
    private final String getter;
    private final String[] getterArgs;
    private final String expected;
    private final boolean isInverse;

    Assertion(int index, String name, String[] args, String assertion, String getter, boolean isBoolean, boolean isInverse) {
        super(index, name, args, CustomCommandProcessor.getArgumentCount(getter) + (isBoolean ? 0 : 1));
        args = this.args;
        this.type = Type.of(assertion);
        this.getter = getter;
        if (isBoolean) {
            this.getterArgs = args;
            this.expected = null;
        } else {
            int len = args.length;
            this.getterArgs = Arrays.copyOf(args, len - 1);
            this.expected = args[len - 1];
        }
        this.isInverse = isInverse;
    }

    @Override
    public Result doCommand(TestCase testCase) {
        CustomCommandProcessor proc = testCase.getProc();
        boolean found = true;
        String message = null;
        int timeout = testCase.getRunner().getTimeout();
        int retryCount = timeout / 100;
        for (int i = 0; i < retryCount; ++i) {
            String error;
            found = true;
            if (i != 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.warn(e.getMessage());
                    break;
                }
            }
            if (this.expected != null) {
                try {
                    Object result = proc.execute(this.getter, this.getterArgs);
                    String resultString = result != null ? result.toString() : "";
                    String expected = testCase.getProc().replaceVars(this.expected);
                    if (this.matches(resultString, expected) ^ this.isInverse) {
                        return Success.SUCCESS;
                    }
                    message = String.format("Assertion failed (Result: [%s] / %sExpected: [%s])", resultString, this.isInverse ? "Not " : "", expected);
                }
                catch (SeleniumException e) {
                    error = e.getMessage();
                    if (!error.endsWith(" not found")) {
                        throw e;
                    }
                    message = String.format("Assertion failed (%s)", error);
                    found = false;
                }
            } else {
                try {
                    boolean result = proc.getBoolean(this.getter, this.getterArgs);
                    if (result ^ this.isInverse) {
                        return Success.SUCCESS;
                    }
                    message = String.format("Assertion failed (Result: [%s] / Expected: [%s])", result, !result);
                }
                catch (SeleniumException e) {
                    error = e.getMessage();
                    if (!error.endsWith(" not found")) {
                        throw e;
                    }
                    message = String.format("Assertion failed (%s)", error);
                    found = false;
                }
            }
            if (this.type != Type.WAIT_FOR) break;
        }
        switch (this.type) {
            case ASSERT: {
                return new Failure(message);
            }
            case VERIFY: {
                return found ? new Warning(message) : new Failure(message);
            }
        }
        return new Warning(String.format("Timed out after %dms (%s)", timeout, message));
    }

    private boolean matches(String resultString, String expected) {
        String[] pattern = expected.split(":", 2);
        if (pattern.length == 2) {
            if ("regexp".equals(pattern[0])) {
                return this.regexpMatches(resultString, pattern[1], 0);
            }
            if ("regexpi".equals(pattern[0])) {
                return this.regexpMatches(resultString, pattern[1], 2);
            }
            if ("exact".equals(pattern[0])) {
                return StringUtils.equals((String)resultString, (String)pattern[1]);
            }
            if ("glob".equals(pattern[0])) {
                expected = pattern[1];
            }
        }
        return this.globMatches(resultString, expected);
    }

    private boolean regexpMatches(String resultString, String expected, int flags) {
        Pattern p = Pattern.compile(expected, flags);
        Matcher m = p.matcher(resultString);
        return m.find();
    }

    private boolean globMatches(String resultString, String expected) {
        Pattern p = Pattern.compile("\\Q" + expected.replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q"));
        Matcher m = p.matcher(resultString);
        return m.matches();
    }

    private static enum Type {
        ASSERT("assert"),
        VERIFY("verify"),
        WAIT_FOR("waitFor");

        private String assertion;

        private Type(String assertion) {
            this.assertion = assertion;
        }

        public static Type of(String assertion) {
            for (Type type : Type.values()) {
                if (!type.assertion.equals(assertion)) continue;
                return type;
            }
            return null;
        }
    }
}

