/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.thoughtworks.selenium.SeleniumException;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.cmdproc.CustomCommandProcessor;
import jp.vmi.selenium.selenese.command.Command;
import jp.vmi.selenium.selenese.result.Failure;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class BuiltInCommand
extends Command {
    private static final String WAIT_FOR_PAGE_TO_LOAD = "waitForPageToLoad";
    private static final String[] CANNOT_UPDATES = new String[]{"createCookie", "deleteCookie", "deleteAllVisibleCookies"};
    private final String realName;
    private final boolean andWait;
    private final boolean canUpdate;

    BuiltInCommand(int index, String name, String[] args, String realName, boolean andWait) {
        super(index, name, args, CustomCommandProcessor.getArgumentCount(realName));
        this.realName = realName;
        this.andWait = andWait;
        this.canUpdate = !ArrayUtils.contains((Object[])CANNOT_UPDATES, (Object)realName);
    }

    @Override
    public boolean canUpdate() {
        return this.canUpdate;
    }

    @Override
    public Result doCommand(TestCase testCase) {
        CustomCommandProcessor proc = testCase.getProc();
        try {
            String resultString;
            Object result = proc.execute(this.realName, this.args);
            String string = resultString = result != null ? result.toString() : "";
            if (this.andWait) {
                int timeout = testCase.getRunner().getTimeout();
                proc.execute(WAIT_FOR_PAGE_TO_LOAD, new String[]{Integer.toString(timeout)});
            }
            return StringUtils.isNotEmpty((String)resultString) ? new Success(resultString) : Success.SUCCESS;
        }
        catch (SeleniumException e) {
            return new Failure("failed command:" + this.toString() + " result:" + e.getMessage());
        }
    }
}

