/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.Arrays;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.utils.LoggerUtils;
import org.apache.commons.lang.StringUtils;

public abstract class Command {
    private final int index;
    protected final String name;
    protected final String[] args;
    protected Command next = null;

    Command(int index, String name, String[] args, int argCnt) {
        this.index = index;
        this.name = name;
        this.args = args.length == argCnt ? args : Arrays.copyOf(args, argCnt);
    }

    public boolean hasResult() {
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    public int getIndex() {
        return this.index;
    }

    public Result doCommand(TestCase testCase) {
        return Success.SUCCESS;
    }

    public Command setNext(Command next) {
        this.next = next;
        return this.next;
    }

    public Command next(TestCase testCase) {
        return this.next;
    }

    public String toString() {
        return "Command#" + this.index + ": " + this.name + "(" + StringUtils.join((Object[])LoggerUtils.quote(this.args), (String)", ") + ")";
    }
}

