/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.thoughtworks.selenium.SeleniumException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.command.AddCollection;
import jp.vmi.selenium.selenese.command.AddToCollection;
import jp.vmi.selenium.selenese.command.Assertion;
import jp.vmi.selenium.selenese.command.BuiltInCommand;
import jp.vmi.selenium.selenese.command.CaptureEntirePageScreenshot;
import jp.vmi.selenium.selenese.command.Command;
import jp.vmi.selenium.selenese.command.Comment;
import jp.vmi.selenium.selenese.command.Echo;
import jp.vmi.selenium.selenese.command.EndFor;
import jp.vmi.selenium.selenese.command.EndWhile;
import jp.vmi.selenium.selenese.command.GotoIf;
import jp.vmi.selenium.selenese.command.Gotolabel;
import jp.vmi.selenium.selenese.command.Label;
import jp.vmi.selenium.selenese.command.Open;
import jp.vmi.selenium.selenese.command.Pause;
import jp.vmi.selenium.selenese.command.SetSpeed;
import jp.vmi.selenium.selenese.command.Store;
import jp.vmi.selenium.selenese.command.StoreFor;
import jp.vmi.selenium.selenese.command.While;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebDriverCommandProcessor;

public class CommandFactory {
    private static final Map<String, Constructor<? extends Command>> constructorMap = new HashMap<String, Constructor<? extends Command>>();
    private static final String AND_WAIT = "AndWait";
    private static final Pattern COMMAND_PATTERN;
    private static final int ASSERTION = 1;
    private static final int IS_INVERSE = 2;
    private static final int TARGET = 3;
    private static final int IS_PRESENT_INVERSE = 4;
    private static final int PRESENT = 5;
    private final WebDriverCommandProcessor proc;

    private static void addConstructor(Class<? extends Command> cmdClass) {
        try {
            String name = StringUtils.uncapitalize((String)cmdClass.getSimpleName());
            Constructor<? extends Command> constructor = cmdClass.getDeclaredConstructor(Integer.TYPE, String.class, String[].class, String.class, Boolean.TYPE);
            constructorMap.put(name, constructor);
        }
        catch (Exception e) {
            throw new SeleniumException(e);
        }
    }

    public CommandFactory(WebDriverCommandProcessor proc) {
        this.proc = proc;
    }

    public Command newCommand(int index, List<String> cmdWithArgs) {
        String name = cmdWithArgs.remove(0);
        return this.newCommand(index, name, cmdWithArgs.toArray(new String[cmdWithArgs.size()]));
    }

    public Command newCommand(int index, String name, String ... args) {
        boolean andWait = name.endsWith(AND_WAIT);
        String realName = andWait ? name.substring(0, name.length() - AND_WAIT.length()) : name;
        Constructor<? extends Command> constructor = constructorMap.get(realName);
        if (constructor != null) {
            try {
                return constructor.newInstance(index, name, args, realName, andWait);
            }
            catch (Exception e) {
                throw new SeleniumException(e);
            }
        }
        if (this.proc.isMethodAvailable(realName)) {
            return new BuiltInCommand(index, name, args, realName, andWait);
        }
        if (realName.matches("(?i)(?:assert|verify|waitFor)(?:Alert|Confirmation|Prompt)(?:(?:Not)?Present)?")) {
            StringBuilder echo = new StringBuilder(name);
            for (String arg : args) {
                echo.append(" ").append(arg);
            }
            return new Echo(index, name, new String[]{echo.toString()}, "echo", false);
        }
        Matcher matcher = COMMAND_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new SeleniumException("No such command: " + name);
        }
        String assertion = matcher.group(1);
        String target = matcher.group(3);
        if (target == null) {
            target = "Expression";
        }
        if (matcher.group(5) != null) {
            target = target + "Present";
        }
        String getter = "get" + target;
        boolean isBoolean = false;
        if (!this.proc.isMethodAvailable(getter)) {
            getter = "is" + target;
            if (!this.proc.isMethodAvailable(getter)) {
                throw new SeleniumException("No such command: " + name);
            }
            isBoolean = true;
        }
        if (assertion != null) {
            boolean isInverse = matcher.group(2) != null || matcher.group(4) != null;
            return new Assertion(index, name, args, assertion, getter, isBoolean, isInverse);
        }
        return new Store(index, name, args, getter);
    }

    public static void addCommandNames(Collection<String> commandNames) {
        for (String name : constructorMap.keySet()) {
            commandNames.add(name);
        }
        commandNames.add("store");
    }

    static {
        CommandFactory.addConstructor(Open.class);
        CommandFactory.addConstructor(Echo.class);
        CommandFactory.addConstructor(CaptureEntirePageScreenshot.class);
        CommandFactory.addConstructor(Pause.class);
        CommandFactory.addConstructor(SetSpeed.class);
        CommandFactory.addConstructor(While.class);
        CommandFactory.addConstructor(EndWhile.class);
        CommandFactory.addConstructor(AddCollection.class);
        CommandFactory.addConstructor(AddToCollection.class);
        CommandFactory.addConstructor(StoreFor.class);
        CommandFactory.addConstructor(EndFor.class);
        CommandFactory.addConstructor(Label.class);
        CommandFactory.addConstructor(Gotolabel.class);
        CommandFactory.addConstructor(GotoIf.class);
        CommandFactory.addConstructor(Comment.class);
        COMMAND_PATTERN = Pattern.compile("(?:(assert|verify|waitFor)(Not)?|store)(?:(.+?)(?:(Not)?(Present))?)?", 2);
    }
}

