/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.inject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jp.vmi.junit.result.JUnitResult;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.command.Command;
import jp.vmi.selenium.selenese.result.Result;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLogInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CommandLogInterceptor.class);
    private static final Comparator<Cookie> cookieComparator = new Comparator<Cookie>(){

        @Override
        public int compare(Cookie c1, Cookie c2) {
            return c1.getName().compareTo(c2.getName());
        }
    };
    private static final FastDateFormat expiryFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private List<String> prevMessages = new ArrayList<String>();

    private void cookieToMessage(List<String> messages, Set<Cookie> cookies) {
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>(cookies);
        Collections.sort(cookieList, cookieComparator);
        for (Cookie cookie : cookieList) {
            Date expiry = cookie.getExpiry();
            String expiryString = expiry != null ? expiryFormat.format(expiry) : "*";
            messages.add(String.format("- Cookie: %s=[%s] (domain=%s, path=%s, expire=%s)", cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), expiryString));
        }
    }

    private void log(Result result, TestCase testCase) {
        ArrayList<String> messages = new ArrayList<String>();
        WebDriver driver = testCase.getRunner().getDriver();
        messages.add(String.format("URL: [%s] / Title: [%s]", driver.getCurrentUrl(), driver.getTitle()));
        this.cookieToMessage(messages, driver.manage().getCookies());
        if (ListUtils.isEqualList(messages, this.prevMessages)) {
            if (result.isFailed()) {
                log.error("- {}", (Object)result);
                JUnitResult.logError(testCase, "-", result.toString());
            } else {
                log.info("- {}", (Object)result);
                JUnitResult.logInfo(testCase, "-", result.toString());
            }
        } else {
            Iterator iter = messages.iterator();
            String message = (String)iter.next();
            if (result.isFailed()) {
                log.error("- {} {}", (Object)result, (Object)message);
                JUnitResult.logError(testCase, "-", result.toString(), message);
                while (iter.hasNext()) {
                    message = (String)iter.next();
                    log.error(message);
                    JUnitResult.logError(testCase, message);
                }
            } else {
                log.info("- {} {}", (Object)result, (Object)message);
                JUnitResult.logInfo(testCase, "-", result.toString(), message);
                while (iter.hasNext()) {
                    message = (String)iter.next();
                    log.info(message);
                    JUnitResult.logInfo(testCase, message);
                }
            }
            this.prevMessages = messages;
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        TestCase testCase = null;
        try {
            testCase = (TestCase)invocation.getThis();
            Command command = (Command)invocation.getArguments()[0];
            log.info(command.toString());
            JUnitResult.logInfo(testCase, command.toString());
            Result result = (Result)invocation.proceed();
            if (command.hasResult()) {
                this.log(result, testCase);
            }
            return result;
        }
        catch (ClassCastException e) {
            String msg = "receiver \"" + invocation.getThis() + "\" is not TestCase: " + e;
            log.error(msg);
            JUnitResult.logError(null, msg);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error(msg);
            JUnitResult.logError(testCase, msg);
            if (testCase != null) {
                JUnitResult.setError(testCase, msg, e.toString());
            }
            throw e;
        }
    }
}

