/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.inject;

import jp.vmi.junit.result.ITestCase;
import jp.vmi.junit.result.ITestSuite;
import jp.vmi.junit.result.JUnitResult;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.LoggerUtils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTestCaseInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExecuteTestCaseInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Result result;
        ITestCase testCase;
        block11: {
            String msg;
            ITestSuite testSuite;
            try {
                testCase = (ITestCase)invocation.getThis();
                testSuite = (ITestSuite)invocation.getArguments()[0];
            }
            catch (Exception e) {
                String msg2 = "receiver is not ITestCase, or 1st argument is not ITestSuite: " + e;
                log.error(msg2);
                JUnitResult.logError(null, msg2);
                throw new RuntimeException(e);
            }
            long stime = System.nanoTime();
            JUnitResult.startTestCase(testSuite, testCase);
            if (!testCase.isError()) {
                log.info("Start: {}", (Object)testCase);
                JUnitResult.logInfo(testCase, "Start:", testCase.toString());
            }
            if (testCase instanceof TestCase) {
                String baseURL = ((TestCase)testCase).getBaseURL();
                log.info("baseURL: {}", (Object)baseURL);
                JUnitResult.logInfo(testCase, "baseURL:", baseURL);
            }
            try {
                Result result2 = (Result)invocation.proceed();
                if (result2.isSuccess()) {
                    JUnitResult.setSuccess(testCase);
                } else {
                    JUnitResult.setFailure(testCase, result2.getMessage(), null);
                }
                result = result2;
                if (testCase.isError()) break block11;
                msg = "End(" + LoggerUtils.durationToString(stime, System.nanoTime()) + "): " + testCase;
            }
            catch (Throwable t) {
                try {
                    String msg3 = t.getMessage();
                    log.error(msg3);
                    JUnitResult.logError(testCase, msg3);
                    JUnitResult.setError(testCase, msg3, t.toString());
                    throw t;
                }
                catch (Throwable throwable) {
                    if (!testCase.isError()) {
                        String msg4 = "End(" + LoggerUtils.durationToString(stime, System.nanoTime()) + "): " + testCase;
                        log.info(msg4);
                        JUnitResult.logInfo(testCase, msg4);
                    }
                    JUnitResult.endTestCase(testCase);
                    throw throwable;
                }
            }
            log.info(msg);
            JUnitResult.logInfo(testCase, msg);
        }
        JUnitResult.endTestCase(testCase);
        return result;
    }
}

