/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.inject;

import jp.vmi.junit.result.ITestSuite;
import jp.vmi.junit.result.JUnitResult;
import jp.vmi.selenium.selenese.utils.LoggerUtils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTestSuiteInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExecuteTestSuiteInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        ITestSuite testSuite;
        try {
            testSuite = (ITestSuite)invocation.getThis();
        }
        catch (Exception e) {
            String msg = "receiver is not ITestSuite: " + e;
            log.error(msg);
            JUnitResult.logError(null, msg);
            throw new RuntimeException(e);
        }
        long stime = System.nanoTime();
        if (!testSuite.isError()) {
            log.info("Start: {}", (Object)testSuite);
            JUnitResult.logInfo(null, "Start:", testSuite.toString());
        }
        JUnitResult.startTestSuite(testSuite);
        try {
            object = invocation.proceed();
        }
        catch (Throwable t) {
            try {
                String msg = t.getMessage();
                log.error(msg);
                JUnitResult.logError(null, msg);
                throw t;
            }
            catch (Throwable throwable) {
                JUnitResult.endTestSuite(testSuite);
                if (!testSuite.isError()) {
                    String msg = "End(" + LoggerUtils.durationToString(stime, System.nanoTime()) + "): " + testSuite;
                    log.info(msg);
                    JUnitResult.logInfo(null, msg);
                }
                throw throwable;
            }
        }
        JUnitResult.endTestSuite(testSuite);
        if (!testSuite.isError()) {
            String msg = "End(" + LoggerUtils.durationToString(stime, System.nanoTime()) + "): " + testSuite;
            log.info(msg);
            JUnitResult.logInfo(null, msg);
        }
        return object;
    }
}

