/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.result;

public abstract class Result {
    private final String message;

    public Result(String message) {
        this.message = message;
    }

    public abstract Level getLevel();

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.getLevel() == Level.SUCCESS;
    }

    public boolean isAborted() {
        return this.getLevel().value >= Level.FAILURE.value;
    }

    public boolean isFailed() {
        return this.getLevel().value >= Level.WARNING.value;
    }

    public Result update(Result newResult) {
        return newResult.getLevel().value > this.getLevel().value ? newResult : this;
    }

    public String toString() {
        return "[" + this.message + "]";
    }

    public static enum Level {
        SUCCESS(0, 0),
        WARNING(1, 0),
        FAILURE(2, 3),
        ERROR(3, 3);

        public final int value;
        public final int exitCode;

        private Level(int value, int exitCode) {
            this.value = value;
            this.exitCode = exitCode;
        }
    }
}

