/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.cmdproc.CustomCommandProcessor;
import jp.vmi.selenium.selenese.command.CommandFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverCommandProcessor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.NoOp;

public class CommandList {
    private static final Pattern GETTER = Pattern.compile("(get|is)([A-Z].*)");

    private static void extractCommandsFromCommandProcessor(Collection<String> commands) {
        try {
            CustomCommandProcessor proc = new CustomCommandProcessor("", new DummyDriver());
            Field methodsField = WebDriverCommandProcessor.class.getDeclaredField("seleneseMethods");
            methodsField.setAccessible(true);
            Map methodsMap = (Map)methodsField.get((Object)proc);
            Set methods = methodsMap.keySet();
            for (String method : methods) {
                if (methodsMap.get(method) instanceof NoOp) continue;
                Matcher matcher = GETTER.matcher(method);
                if (matcher.matches()) {
                    String name = matcher.group(2);
                    commands.add("assert" + name);
                    commands.add("verify" + name);
                    commands.add("waitFor" + name);
                    commands.add("store" + name);
                    if (name.endsWith("Present")) {
                        String notName = name.replaceFirst("Present$", "NotPresent");
                        commands.add("assert" + notName);
                        commands.add("verify" + notName);
                        commands.add("waitFor" + notName);
                        continue;
                    }
                    commands.add("assertNot" + name);
                    commands.add("verifyNot" + name);
                    commands.add("waitForNot" + name);
                    continue;
                }
                commands.add(method);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        HashSet<String> commandNames = new HashSet<String>();
        CommandList.extractCommandsFromCommandProcessor(commandNames);
        CommandFactory.addCommandNames(commandNames);
        ArrayList<String> result = new ArrayList<String>(commandNames);
        Collections.sort(result);
        for (String name : result) {
            System.out.println(name);
        }
    }

    private static class DummyDriver
    implements WebDriver,
    JavascriptExecutor {
        private DummyDriver() {
        }

        public void get(String url) {
        }

        public String getCurrentUrl() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public List<WebElement> findElements(By by) {
            return null;
        }

        public WebElement findElement(By by) {
            return null;
        }

        public String getPageSource() {
            return null;
        }

        public void close() {
        }

        public void quit() {
        }

        public Set<String> getWindowHandles() {
            return null;
        }

        public String getWindowHandle() {
            return null;
        }

        public WebDriver.TargetLocator switchTo() {
            return null;
        }

        public WebDriver.Navigation navigate() {
            return null;
        }

        public WebDriver.Options manage() {
            return null;
        }

        public Object executeScript(String script, Object ... args) {
            return null;
        }

        public Object executeAsyncScript(String script, Object ... args) {
            return null;
        }
    }
}

