/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;

public class ChromeDriverFactory
extends WebDriverFactory {
    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        ChromeDriverService.Builder builder = new ChromeDriverService.Builder();
        if (driverOptions.has(DriverOptions.DriverOption.CHROMEDRIVER)) {
            builder = builder.usingDriverExecutable(new File(driverOptions.get(DriverOptions.DriverOption.CHROMEDRIVER)));
        }
        builder = builder.usingAnyFreePort().withEnvironment(this.getEnvironmentVariables());
        ChromeDriverService service = builder.build();
        ChromeOptions options = new ChromeOptions();
        if (driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            options.addArguments(new String[]{"--proxy-server=http://" + driverOptions.get(DriverOptions.DriverOption.PROXY)});
        }
        return new ChromeDriver(service, options);
    }
}

