/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.util.IdentityHashMap;
import org.apache.commons.cli.CommandLine;

public class DriverOptions {
    private final IdentityHashMap<DriverOption, String> map = new IdentityHashMap();

    public DriverOptions() {
    }

    public DriverOptions(CommandLine cli) {
        for (DriverOption opt : DriverOption.values()) {
            String key = opt.name().toLowerCase().replace('_', '-');
            this.set(opt, cli.getOptionValue(key));
        }
    }

    public String get(DriverOption opt) {
        return this.map.get((Object)opt);
    }

    public boolean has(DriverOption opt) {
        return this.map.containsKey((Object)opt);
    }

    public DriverOptions set(DriverOption opt, String value) {
        if (value != null) {
            this.map.put(opt, value);
        } else {
            this.map.remove((Object)opt);
        }
        return this;
    }

    public String toString() {
        if (this.map.isEmpty()) {
            return "[]";
        }
        StringBuilder result = new StringBuilder("[");
        for (DriverOption opt : DriverOption.values()) {
            if (!this.map.containsKey((Object)opt)) continue;
            result.append(opt.name()).append('=').append(this.map.get((Object)opt)).append("|");
        }
        result.setCharAt(result.length() - 1, ']');
        return result.toString();
    }

    public static enum DriverOption {
        PROFILE,
        PROFILE_DIR,
        PROXY,
        PROXY_USER,
        PROXY_PASSWORD,
        NO_PROXY,
        CHROMEDRIVER,
        IEDRIVER;

    }
}

