/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.WebClient;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class HtmlUnitDriverFactory
extends WebDriverFactory {
    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        String proxyPassword;
        String proxyUser;
        int proxyPort;
        String proxyHost;
        DesiredCapabilities capabilities = this.setupProxy(DesiredCapabilities.htmlUnit(), driverOptions);
        capabilities.setJavascriptEnabled(true);
        String proxy = driverOptions.get(DriverOptions.DriverOption.PROXY);
        if (proxy != null) {
            String[] hp = proxy.split(":", 2);
            proxyHost = hp[0];
            proxyPort = NumberUtils.toInt((String)hp[1]);
            String u = driverOptions.get(DriverOptions.DriverOption.PROXY_USER);
            String p = driverOptions.get(DriverOptions.DriverOption.PROXY_PASSWORD);
            if (u != null && p == null) {
                p = "";
            } else if (u == null && p != null) {
                u = "";
            }
            proxyUser = u;
            proxyPassword = p;
        } else {
            proxyHost = null;
            proxyPort = 0;
            proxyUser = null;
            proxyPassword = null;
        }
        return new HtmlUnitDriver((Capabilities)capabilities){

            protected WebClient modifyWebClient(WebClient client) {
                if (proxyUser != null) {
                    DefaultCredentialsProvider cp = new DefaultCredentialsProvider();
                    cp.addCredentials(proxyUser, proxyPassword, proxyHost, proxyPort, AuthScope.ANY_REALM);
                    client.setCredentialsProvider((CredentialsProvider)cp);
                }
                return client;
            }
        };
    }
}

