/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEDriverFactory
extends WebDriverFactory {
    private static Logger log = LoggerFactory.getLogger(IEDriverFactory.class);

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        Platform platform = Platform.getCurrent();
        log.info("Platform: {}", (Object)platform);
        switch (platform) {
            case WINDOWS: 
            case XP: 
            case VISTA: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported platform: " + platform);
            }
        }
        if (driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            log.warn("No support proxy with InternetExprolerDriver. Please set proxy to IE in advance.");
        }
        if (driverOptions.has(DriverOptions.DriverOption.IEDRIVER)) {
            File ieds = new File(driverOptions.get(DriverOptions.DriverOption.IEDRIVER));
            if (!ieds.canExecute()) {
                throw new IllegalArgumentException("Missing IEDriverServer.exe: " + ieds);
            }
            InternetExplorerDriverService is = new InternetExplorerDriverService.Builder().usingAnyFreePort().usingDriverExecutable(ieds).build();
            return new InternetExplorerDriver(is);
        }
        return new InternetExplorerDriver();
    }
}

