/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.util.HashMap;
import java.util.Map;
import jp.vmi.selenium.webdriver.DriverOptions;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public abstract class WebDriverFactory {
    Map<String, String> environmentVariables = new HashMap<String, String>();

    protected DesiredCapabilities setupProxy(DesiredCapabilities capabilities, DriverOptions driverOptions) {
        if (driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            Proxy proxy = new Proxy();
            proxy.setProxyType(Proxy.ProxyType.MANUAL);
            String ps = driverOptions.get(DriverOptions.DriverOption.PROXY);
            proxy.setHttpProxy(ps).setSslProxy(ps).setFtpProxy(ps);
            if (driverOptions.has(DriverOptions.DriverOption.NO_PROXY)) {
                proxy.setNoProxy(driverOptions.get(DriverOptions.DriverOption.NO_PROXY));
            }
            capabilities.setCapability("proxy", (Object)proxy);
        }
        return capabilities;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public abstract WebDriver newInstance(DriverOptions var1);
}

