/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import jp.vmi.selenium.webdriver.ChromeDriverFactory;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.FirefoxDriverFactory;
import jp.vmi.selenium.webdriver.HtmlUnitDriverFactory;
import jp.vmi.selenium.webdriver.IEDriverFactory;
import jp.vmi.selenium.webdriver.SafariDriverFactory;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverManager
implements Supplier<WebDriver> {
    private static final Logger log = LoggerFactory.getLogger(WebDriverManager.class);
    public static final String FIREFOX = "firefox";
    public static final String CHROME = "chrome";
    public static final String IE = "ie";
    public static final String HTMLUNIT = "htmlunit";
    public static final String SAFARI = "safari";
    public static final String WEBDRIVER_FACTORY = "jp.vmi.selenium.webdriver.factory";
    private static final WebDriverManager manager = new WebDriverManager();
    private boolean isSingleInstance = true;
    private WebDriverFactory factory;
    private DriverOptions driverOptions = new DriverOptions();
    private final Map<String, WebDriver> driverMap = new HashMap<String, WebDriver>();
    private final Map<String, String> environmentVariables = new HashMap<String, String>();

    public static WebDriverManager getInstance() {
        return manager;
    }

    public WebDriverManager() {
        String factoryName = System.getProperty(WEBDRIVER_FACTORY, FIREFOX);
        this.setWebDriverFactory(factoryName);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WebDriverManager.this.quitAllDrivers();
            }
        });
    }

    public boolean isSingleInstance() {
        return this.isSingleInstance;
    }

    public void setSingleInstance(boolean isSingleInstance) {
        this.isSingleInstance = isSingleInstance;
    }

    public void setWebDriverFactory(WebDriverFactory factory) {
        this.factory = factory;
    }

    public void setWebDriverFactory(String factoryName) {
        WebDriverFactory factory;
        if (FIREFOX.equals(factoryName = StringUtils.isBlank((String)factoryName) ? FIREFOX : factoryName.toLowerCase())) {
            factory = new FirefoxDriverFactory();
        } else if (CHROME.equals(factoryName)) {
            factory = new ChromeDriverFactory();
        } else if (IE.equals(factoryName)) {
            factory = new IEDriverFactory();
        } else if (SAFARI.equals(factoryName)) {
            factory = new SafariDriverFactory();
        } else if (HTMLUNIT.equals(factoryName)) {
            factory = new HtmlUnitDriverFactory();
        } else {
            try {
                factory = (WebDriverFactory)Class.forName(factoryName).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid WebDriverFactory class name: " + factoryName, e);
            }
        }
        this.setWebDriverFactory(factory);
    }

    public DriverOptions getDriverOptions() {
        return this.driverOptions;
    }

    public void setDriverOptions(DriverOptions driverOptions) {
        this.driverOptions = driverOptions;
    }

    private String getDriverName(WebDriver driver) {
        String name = driver.getClass().getSimpleName();
        if (StringUtils.isNotBlank((String)name)) {
            return name;
        }
        return driver.getClass().getName();
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public synchronized WebDriver get() throws IllegalArgumentException {
        this.factory.getEnvironmentVariables().clear();
        this.factory.getEnvironmentVariables().putAll(this.getEnvironmentVariables());
        String key = this.factory.getClass().getCanonicalName() + this.driverOptions.toString();
        WebDriver driver = this.driverMap.get(key);
        if (driver == null) {
            if (this.isSingleInstance) {
                this.quitAllDrivers();
            }
            driver = this.factory.newInstance(this.driverOptions);
            log.info("Initialized: {}", (Object)this.getDriverName(driver));
            this.driverMap.put(key, driver);
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void quitAllDrivers() {
        for (WebDriver driver : this.driverMap.values()) {
            try {
                driver.quit();
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
            finally {
                log.info("Quit: {}", (Object)this.getDriverName(driver));
            }
        }
        this.driverMap.clear();
    }
}

