/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.html.result;

import com.floreysoft.jmte.AnnotationProcessor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.token.AnnotationToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import jp.vmi.html.result.HtmlEscapeRenderer;
import jp.vmi.html.result.IndexRenderer;
import jp.vmi.html.result.LogRenderer;
import jp.vmi.html.result.NodeRenderer;
import jp.vmi.html.result.NumberRenderer;
import jp.vmi.html.result.RelativePathRenderer;
import jp.vmi.html.result.ResultRenderer;
import jp.vmi.html.result.StringRenderer;
import jp.vmi.html.result.TestSuiteSummary;
import jp.vmi.html.result.TestSuiteTree;
import jp.vmi.html.result.TimeRenderer;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.TestSuite;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.result.CommandResult;
import jp.vmi.selenium.selenese.result.CommandResultList;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.SystemInformation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlResult {
    private static final Logger log = LoggerFactory.getLogger(HtmlResult.class);
    private String[] commandLineArgs = null;
    private String htmlResultDir = null;
    private Engine engine = null;
    private final TestSuiteTree tree = new TestSuiteTree();

    public void setCommandLineArgs(String[] args) {
        this.commandLineArgs = args;
    }

    public String getDir() {
        return this.htmlResultDir;
    }

    public void setDir(String dir) {
        this.htmlResultDir = dir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTemplate(String filename) {
        try (InputStream is = this.getClass().getResourceAsStream(filename);){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Engine getEngine() {
        if (this.engine == null) {
            this.engine = Engine.createCompilingEngine();
            this.engine.registerNamedRenderer((NamedRenderer)new HtmlEscapeRenderer());
            this.engine.registerNamedRenderer((NamedRenderer)new LogRenderer(this));
            this.engine.registerNamedRenderer((NamedRenderer)new IndexRenderer());
            this.engine.registerNamedRenderer((NamedRenderer)new RelativePathRenderer(this));
            this.engine.registerNamedRenderer((NamedRenderer)new NumberRenderer());
            this.engine.registerNamedRenderer((NamedRenderer)new TimeRenderer());
            this.engine.registerNamedRenderer((NamedRenderer)new StringRenderer());
            this.engine.registerRenderer(Result.class, (Renderer)new ResultRenderer());
            this.engine.registerRenderer(TestSuiteTree.Node.class, (Renderer)new NodeRenderer(this.engine, this.getTemplate("index-node.html")));
            this.engine.registerAnnotationProcessor((AnnotationProcessor)new AnnoCommandResults());
        }
        return this.engine;
    }

    public TestSuiteSummary generate(TestSuite testSuite) {
        if (this.htmlResultDir == null) {
            return null;
        }
        TestSuiteSummary summary = this.tree.getSummary(testSuite);
        if (summary != null) {
            return summary;
        }
        List<Selenese> seleneseList = testSuite.getSeleneseList();
        summary = new TestSuiteSummary();
        for (Selenese selenese : seleneseList) {
            switch (selenese.getType()) {
                case TEST_SUITE: {
                    if (selenese.isError()) break;
                    summary.merge(this.generate((TestSuite)selenese));
                    break;
                }
                case TEST_CASE: {
                    ++summary.numTestTotal;
                    if (selenese.isError()) {
                        ++summary.numTestFailures;
                        break;
                    }
                    TestCase testCase = (TestCase)selenese;
                    switch (testCase.getResult().getLevel()) {
                        case UNEXECUTED: {
                            break;
                        }
                        case SUCCESS: 
                        case WARNING: {
                            ++summary.numTestPasses;
                            break;
                        }
                        case FAILURE: 
                        case ERROR: 
                        case MAX_TIME_EXCEEDED: {
                            ++summary.numTestFailures;
                        }
                    }
                    for (ICommand command : testCase.getCommandList()) {
                        switch (command.getResult().getLevel()) {
                            case UNEXECUTED: {
                                break;
                            }
                            case SUCCESS: 
                            case WARNING: {
                                ++summary.numCommandPasses;
                                break;
                            }
                            case FAILURE: {
                                ++summary.numCommandFailures;
                                break;
                            }
                            case ERROR: 
                            case MAX_TIME_EXCEEDED: {
                                ++summary.numCommandErrors;
                            }
                        }
                    }
                    break;
                }
            }
        }
        File dir = new File(this.htmlResultDir);
        if (!dir.exists()) {
            dir.mkdirs();
            log.info("Make the directory for HTML resut: {}", (Object)dir);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("title", testSuite.getName() + " results");
        model.put("sysInfo", SystemInformation.getInstance());
        model.put("testSuite", testSuite);
        model.put("seleneseList", seleneseList);
        model.put("numTestTotal", summary.numTestTotal);
        model.put("numTestPasses", summary.numTestPasses);
        model.put("numTestFailures", summary.numTestFailures);
        model.put("numCommandPasses", summary.numCommandPasses);
        model.put("numCommandFailures", summary.numCommandFailures);
        model.put("numCommandErrors", summary.numCommandErrors);
        model.put("commandLine", this.commandLineArgs);
        String html = this.getEngine().transform(this.getTemplate("result.html"), model);
        File file = new File(dir, "TEST-" + testSuite.getBaseName() + ".html");
        try {
            FileUtils.write((File)file, (CharSequence)html, (String)"UTF-8");
            log.info("Generated HTML result: {}", (Object)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tree.add(testSuite, summary);
        return summary;
    }

    public void generateIndex() {
        if (this.htmlResultDir == null) {
            return;
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("title", "Index of test-suite results.");
        model.put("tree", this.tree);
        String html = this.getEngine().transform(this.getTemplate("index.html"), model);
        File file = new File(this.htmlResultDir, "index.html");
        try {
            FileUtils.write((File)file, (CharSequence)html);
            log.info("Generated index of HTML results: {}", (Object)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class AnnoCommandResults
    implements AnnotationProcessor<String> {
        private AnnoCommandResults() {
        }

        public String getType() {
            return "commandResults";
        }

        public String eval(AnnotationToken token, TemplateContext context) {
            String[] args = token.getArguments().split("\\s+");
            TestCase testCase = (TestCase)context.model.get((Object)args[1]);
            CommandResultList cresultList = testCase.getResultList();
            ICommand command = (ICommand)context.model.get((Object)args[2]);
            List<CommandResult> results = cresultList.getResults(command);
            context.model.put(args[0], results);
            return null;
        }
    }
}

