/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import com.thoughtworks.selenium.SeleniumException;
import java.util.Map;
import jp.vmi.selenium.selenese.utils.JSFunction;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class DialogOverride {
    private static final JSFunction replaceAlertMethod;
    private static final JSFunction getNextAlert;
    private static final JSFunction isAlertPresent;
    private static final JSFunction getNextConfirmation;
    private static final JSFunction isConfirmationPresent;
    private static final JSFunction answerOnNextPrompt;
    private static final JSFunction getNextPrompt;
    private static final JSFunction isPromptPresent;

    public void replaceAlertMethod(WebDriver driver, WebElement element) {
        replaceAlertMethod.call(driver, element);
    }

    public String getNextAlert(WebDriver driver) {
        String result = (String)getNextAlert.call(driver, new Object[0]);
        if (result == null) {
            throw new SeleniumException("There were no alerts");
        }
        return result;
    }

    public boolean isAlertPresent(WebDriver driver) {
        return Boolean.TRUE.equals(isAlertPresent.call(driver, new Object[0]));
    }

    public String getNextConfirmation(WebDriver driver) {
        String result = (String)getNextConfirmation.call(driver, new Object[0]);
        if (result == null) {
            throw new SeleniumException("There were no confirmations");
        }
        return result;
    }

    public boolean isConfirmationPresent(WebDriver driver) {
        return Boolean.TRUE.equals(isConfirmationPresent.call(driver, new Object[0]));
    }

    public void answerOnNextPrompt(WebDriver driver, String msg) {
        answerOnNextPrompt.call(driver, msg);
    }

    public String getNextPrompt(WebDriver driver) {
        String result = (String)getNextPrompt.call(driver, new Object[0]);
        if (result == null) {
            throw new SeleniumException("There were no prompts");
        }
        return result;
    }

    public boolean isPromptPresent(WebDriver driver) {
        return Boolean.TRUE.equals(isPromptPresent.call(driver, new Object[0]));
    }

    static {
        Map<String, JSFunction> jsMap = JSFunction.load(DialogOverride.class.getResourceAsStream("DialogOverride.js"));
        replaceAlertMethod = jsMap.get("replaceAlertMethod");
        getNextAlert = jsMap.get("getNextAlert");
        isAlertPresent = jsMap.get("isAlertPresent");
        getNextConfirmation = jsMap.get("getNextConfirmation");
        isConfirmationPresent = jsMap.get("isConfirmationPresent");
        answerOnNextPrompt = jsMap.get("answerOnNextPrompt");
        getNextPrompt = jsMap.get("getNextPrompt");
        isPromptPresent = jsMap.get("isPromptPresent");
    }
}

