/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class ClickAt
extends AbstractCommand {
    private static final int ARG_LOCATOR = 0;
    private static final int ARG_COORD = 1;

    ClickAt(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR);
    }

    private static Point coordToPoint(String coordString) {
        String[] pair = coordString.trim().split("\\s*,\\s*");
        int x = (int)Double.parseDouble(pair[0]);
        int y = (int)Double.parseDouble(pair[1]);
        return new Point(x, y);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String locator = curArgs[0];
        Point coord = curArgs.length > 1 ? ClickAt.coordToPoint(curArgs[1]) : new Point(0, 0);
        WebDriver driver = context.getWrappedDriver();
        WebElement element = context.getElementFinder().findElement(driver, locator);
        context.getDialogOverride().replaceAlertMethod(driver, element);
        new Actions(driver).moveToElement(element, coord.x, coord.y).click().perform();
        return Success.SUCCESS;
    }
}

