/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.locator.WebDriverElementFinder;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Select
extends AbstractCommand {
    private static final int ARG_SELECT_LOCATOR = 0;
    private static final int ARG_OPTION_LOCATOR = 1;

    Select(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR, ArgumentType.OPTION_LOCATOR);
    }

    private boolean isMultiple(WebElement select) {
        String multiple = select.getAttribute("multiple");
        return multiple != null && (multiple.equalsIgnoreCase("true") || multiple.equalsIgnoreCase("multiple"));
    }

    private void unsetOptions(WebElement select) {
        for (WebElement option : select.findElements(By.tagName((String)"option"))) {
            if (!option.isSelected()) continue;
            option.click();
        }
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        WebElement option;
        String selectLocator = curArgs[0];
        String optionLocator = WebDriverElementFinder.convertToOptionLocatorWithParent(selectLocator, curArgs[1]);
        WebDriver driver = context.getWrappedDriver();
        WebDriverElementFinder finder = context.getElementFinder();
        WebElement select = finder.findElement(driver, selectLocator);
        context.getDialogOverride().replaceAlertMethod(driver, select);
        if (this.isMultiple(select)) {
            this.unsetOptions(select);
        }
        if (!(option = finder.findElement(driver, optionLocator)).isSelected()) {
            option.click();
        }
        return Success.SUCCESS;
    }
}

