/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.result.Warning;
import org.apache.commons.lang3.StringUtils;

public class SetSpeed
extends AbstractCommand {
    private static final int ARG_SPEED = 0;

    SetSpeed(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE);
    }

    @Override
    public boolean mayUpdateScreen() {
        return false;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String speed = curArgs[0];
        if (StringUtils.isBlank((CharSequence)speed)) {
            return new Warning("the argument of setSpeed is ignored: empty.");
        }
        try {
            context.setSpeed(Long.parseLong(speed));
            return Success.SUCCESS;
        }
        catch (NumberFormatException e) {
            return new Warning("the argument of setSpeed is ignored: invalid number format: " + speed);
        }
    }
}

