/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.locator;

import java.util.ArrayList;
import java.util.List;
import jp.vmi.selenium.selenese.locator.LocatorHandler;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalHandler
implements LocatorHandler {
    private static final Logger log = LoggerFactory.getLogger(AdditionalHandler.class);
    private final String locatorType;
    private final String script;

    public AdditionalHandler(String locatorType, String script) {
        this.locatorType = locatorType;
        this.script = script;
    }

    @Override
    public String locatorType() {
        return this.locatorType;
    }

    @Override
    public List<WebElement> handle(WebDriver driver, String arg) {
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        if (driver instanceof JavascriptExecutor) {
            Object element = ((JavascriptExecutor)driver).executeScript(this.script, new Object[]{arg});
            if (element instanceof WebElement) {
                result.add((WebElement)element);
            }
        } else {
            log.warn("The current WebDriver does not support JavaScript execution.");
        }
        return result;
    }
}

