/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.subcommand;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.subcommand.AbstractSubCommand;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;

public class GetAllWindowNames
extends AbstractSubCommand<List<String>> {
    public GetAllWindowNames() {
        super(new ArgumentType[0]);
    }

    private static boolean switchToWindow(WebDriver driver, String handle) {
        try {
            driver.switchTo().window(handle);
            return true;
        }
        catch (NoSuchWindowException e) {
            return false;
        }
    }

    private static String getNameOrHandle(WebDriver driver, String handle) {
        String name = ((JavascriptExecutor)driver).executeScript("return window.name", new Object[0]).toString();
        return name == null || name.isEmpty() ? handle : name;
    }

    @Override
    public List<String> execute(Context context, String ... args) {
        WebDriver driver = context.getWrappedDriver();
        String initHandle = context.getInitialWindowHandle();
        String currentHandle = driver.getWindowHandle();
        Set handles = driver.getWindowHandles();
        ArrayList<String> result = new ArrayList<String>(handles.size());
        result.add(GetAllWindowNames.getNameOrHandle(driver, currentHandle));
        handles.remove(currentHandle);
        if (!currentHandle.equals(initHandle) && handles.contains(initHandle)) {
            GetAllWindowNames.switchToWindow(driver, initHandle);
            result.add(0, GetAllWindowNames.getNameOrHandle(driver, initHandle));
            handles.remove(initHandle);
        }
        for (String handle : handles) {
            if (!GetAllWindowNames.switchToWindow(driver, handle)) continue;
            result.add(GetAllWindowNames.getNameOrHandle(driver, handle));
        }
        GetAllWindowNames.switchToWindow(driver, currentHandle);
        return result;
    }
}

