/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Platform;

public final class CommandLineUtils {
    private static final Pattern RE_W = Pattern.compile("\\G(?:%+|\"|[^%\"]+)");
    private static final Pattern RE_U = Pattern.compile("\\G(?:'|[^']+)");

    private CommandLineUtils() {
    }

    public static void addEscapedArgumentOnWindows(StringBuilder buffer, String arg) {
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        boolean quoted = false;
        Matcher matcher = RE_W.matcher(arg);
        while (matcher.find()) {
            String matched = matcher.group();
            char c = matched.charAt(0);
            if (c == '%') {
                if (quoted) {
                    if (buffer.charAt(buffer.length() - 1) == '\\') {
                        buffer.append('\\');
                    }
                    buffer.append('\"').append(matched);
                    quoted = false;
                    continue;
                }
                buffer.append(matched);
                continue;
            }
            if (!quoted) {
                buffer.append('\"');
                quoted = true;
            }
            if (c == '\"') {
                buffer.append('\\');
            }
            buffer.append(matched);
        }
        if (quoted) {
            if (buffer.charAt(buffer.length() - 1) == '\\') {
                buffer.append('\\');
            }
            buffer.append('\"');
        }
    }

    public static void addEscapedArgumentOnUnix(StringBuilder buffer, String arg) {
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        boolean quoted = false;
        Matcher matcher = RE_U.matcher(arg);
        while (matcher.find()) {
            String matched = matcher.group();
            char c = matched.charAt(0);
            if (c == '\'') {
                if (quoted) {
                    buffer.append('\'');
                    quoted = false;
                }
                buffer.append("\\'");
                continue;
            }
            if (!quoted) {
                buffer.append('\'');
                quoted = true;
            }
            buffer.append(matched);
        }
        if (quoted) {
            buffer.append('\'');
        }
    }

    public static String espaceCommandLineArgs(String[] args) {
        boolean isWindows = Platform.getCurrent().is(Platform.WINDOWS);
        StringBuilder buffer = new StringBuilder();
        for (String arg : args) {
            if (isWindows) {
                CommandLineUtils.addEscapedArgumentOnWindows(buffer, arg);
                continue;
            }
            CommandLineUtils.addEscapedArgumentOnUnix(buffer, arg);
        }
        return buffer.toString();
    }
}

