/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;

public class ApacheHttpAsyncClient
implements HttpClient {
    private static final int MAX_REDIRECTS = 10;
    private final URL url;
    private final HttpHost targetHost;
    private final CloseableHttpAsyncClient client;

    public ApacheHttpAsyncClient(CloseableHttpAsyncClient client, URL url) {
        this.client = (CloseableHttpAsyncClient)Preconditions.checkNotNull((Object)client, (Object)"null HttpClient");
        this.url = (URL)Preconditions.checkNotNull((Object)url, (Object)"null URL");
        String host = url.getHost().replace(".localdomain", "");
        this.targetHost = new HttpHost(host, url.getPort(), url.getProtocol());
    }

    public org.openqa.selenium.remote.http.HttpResponse execute(org.openqa.selenium.remote.http.HttpRequest request, boolean followRedirects) throws IOException {
        HttpContext context = this.createContext();
        String requestUrl = this.url.toExternalForm().replaceAll("/$", "") + request.getUri();
        HttpUriRequest httpMethod = ApacheHttpAsyncClient.createHttpUriRequest(request.getMethod(), requestUrl);
        for (String name : request.getHeaderNames()) {
            if ("Content-Length".equalsIgnoreCase(name)) continue;
            for (String value : request.getHeaders(name)) {
                httpMethod.addHeader(name, value);
            }
        }
        if (httpMethod instanceof HttpPost) {
            ((HttpPost)httpMethod).setEntity((HttpEntity)new ByteArrayEntity(request.getContent()));
        }
        this.client.start();
        Future future = this.client.execute(this.targetHost, (HttpRequest)httpMethod, context, null);
        try {
            HttpResponse response = (HttpResponse)future.get();
            if (followRedirects) {
                response = this.followRedirects(this.client, context, response, 0);
            }
            return this.createResponse(response, context);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.openqa.selenium.remote.http.HttpResponse createResponse(HttpResponse response, HttpContext context) throws IOException {
        Object host;
        org.openqa.selenium.remote.http.HttpResponse internalResponse = new org.openqa.selenium.remote.http.HttpResponse();
        internalResponse.setStatus(response.getStatusLine().getStatusCode());
        for (Header header : response.getAllHeaders()) {
            for (HeaderElement headerElement : header.getElements()) {
                internalResponse.addHeader(header.getName(), headerElement.getValue());
            }
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try {
                internalResponse.setContent(EntityUtils.toByteArray((HttpEntity)entity));
            }
            finally {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        if ((host = context.getAttribute("http.target_host")) instanceof HttpHost) {
            internalResponse.setTargetHost(((HttpHost)host).toURI());
        }
        return internalResponse;
    }

    protected HttpContext createContext() {
        return new BasicHttpContext();
    }

    private static HttpUriRequest createHttpUriRequest(HttpMethod method, String url) {
        switch (method) {
            case DELETE: {
                return new HttpDelete(url);
            }
            case GET: {
                return new HttpGet(url);
            }
            case POST: {
                return new HttpPost(url);
            }
        }
        throw new AssertionError((Object)("Unsupported method: " + method));
    }

    private HttpResponse followRedirects(CloseableHttpAsyncClient client, HttpContext context, HttpResponse response, int redirectCount) {
        URI uri;
        if (!this.isRedirect(response)) {
            return response;
        }
        try {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (redirectCount > 10) {
            throw new WebDriverException("Maximum number of redirects exceeded. Aborting");
        }
        String location = response.getFirstHeader("location").getValue();
        try {
            uri = this.buildUri(context, location);
        }
        catch (URISyntaxException e) {
            throw new WebDriverException((Throwable)e);
        }
        HttpGet get = new HttpGet(uri);
        get.setHeader("Accept", "application/json; charset=utf-8");
        Future future = client.execute(this.targetHost, (HttpRequest)get, context, null);
        try {
            HttpResponse newResponse = (HttpResponse)future.get();
            return this.followRedirects(client, context, newResponse, redirectCount + 1);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private URI buildUri(HttpContext context, String location) throws URISyntaxException {
        URI uri = new URI(location);
        if (!uri.isAbsolute()) {
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            uri = new URI(host.toURI() + location);
        }
        return uri;
    }

    private boolean isRedirect(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return (code == 301 || code == 302 || code == 303 || code == 307) && response.containsHeader("location");
    }

    public void close() throws IOException {
        this.client.close();
    }
}

