/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.net.ProxySelector;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.internal.ApacheHttpAsyncClient;

public class ApacheHttpAsyncClientFactory
implements HttpClient.Factory {
    private final int TIMEOUT_THREE_HOURS = (int)TimeUnit.SECONDS.toMillis(10800L);
    private final int TIMEOUT_TWO_MINUTES = (int)TimeUnit.SECONDS.toMillis(120L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceDefaultClientFactory() throws Exception {
        Class<?> factoryClass = Class.forName("org.openqa.selenium.remote.HttpCommandExecutor");
        Field defaultClientFactory = factoryClass.getDeclaredField("defaultClientFactory");
        defaultClientFactory.setAccessible(true);
        Class<?> clazz = factoryClass;
        synchronized (clazz) {
            HttpClient.Factory factory = (HttpClient.Factory)defaultClientFactory.get(null);
            if (factory == null || !(factory instanceof ApacheHttpAsyncClientFactory)) {
                defaultClientFactory.set(null, new ApacheHttpAsyncClientFactory());
            }
        }
    }

    public HttpClient createClient(URL url) {
        DefaultConnectingIOReactor ioReactor;
        int connectionTimeout = this.TIMEOUT_TWO_MINUTES;
        int socketTimeout = this.TIMEOUT_THREE_HOURS;
        Preconditions.checkNotNull((Object)url, (Object)"null URL");
        if (connectionTimeout <= 0) {
            throw new IllegalArgumentException("connection timeout must be > 0");
        }
        if (socketTimeout <= 0) {
            throw new IllegalArgumentException("socket timeout must be > 0");
        }
        RequestConfig requestConfig = RequestConfig.custom().setStaleConnectionCheckEnabled(true).setConnectTimeout(connectionTimeout).setSocketTimeout(socketTimeout).build();
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner((SchemePortResolver)new DefaultSchemePortResolver(), ProxySelector.getDefault());
        try {
            ioReactor = new DefaultConnectingIOReactor();
        }
        catch (IOReactorException e) {
            throw new RuntimeException(e);
        }
        PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        cm.setMaxTotal(2000);
        cm.setDefaultMaxPerRoute(2000);
        HttpAsyncClientBuilder builder = HttpAsyncClientBuilder.create().setConnectionManager((NHttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).setRoutePlanner((HttpRoutePlanner)routePlanner);
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            String password;
            String user;
            int sep = userInfo.indexOf(58);
            if (sep >= 0) {
                user = userInfo.substring(0, sep);
                password = userInfo.substring(sep + 1);
            } else {
                user = userInfo;
                password = null;
            }
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        return new ApacheHttpAsyncClient(builder.build(), url);
    }
}

