/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.html.result;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.html.result.HtmlResult;
import jp.vmi.selenium.selenese.utils.EscapeUtils;
import jp.vmi.selenium.selenese.utils.PathUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class LogRenderer
implements NamedRenderer {
    private static final Pattern RE = Pattern.compile("(\\[\\[ATTACHMENT\\|)(.*?)(\\]\\])|(" + EscapeUtils.HTML_RE.pattern() + ")");
    private static final int ATTACHMENT_PREFIX = 1;
    private static final int ATTACHMENT_PATH = 2;
    private static final int ATTACHMENT_SUFFIX = 3;
    private static final int SPECIALS = 4;
    private final HtmlResult htmlResult;

    public LogRenderer(HtmlResult htmlResult) {
        this.htmlResult = htmlResult;
    }

    public RenderFormatInfo getFormatInfo() {
        return null;
    }

    public String getName() {
        return "log";
    }

    public Class<?>[] getSupportedClasses() {
        return new Class[]{Object.class};
    }

    public String render(Object o, String format, Locale locale) {
        StringBuilder result = new StringBuilder();
        String s = o.toString();
        Matcher matcher = RE.matcher(s);
        int index = 0;
        while (matcher.find(index)) {
            String prefix;
            int start = matcher.start();
            if (index < start) {
                result.append(s, index, start);
            }
            if ((prefix = matcher.group(1)) != null) {
                String path = matcher.group(2);
                String relPath = PathUtils.relativize(this.htmlResult.getDir(), path);
                result.append(prefix).append("<a href=\"").append(EscapeUtils.encodeUri(relPath)).append("\">").append(StringEscapeUtils.escapeHtml4((String)path)).append("</a>").append(matcher.group(3));
            } else {
                result.append(EscapeUtils.HTML_ESC_MAP.get(matcher.group(4)));
            }
            index = matcher.end();
        }
        if (index < s.length()) {
            result.append(s, index, s.length());
        }
        return result.toString();
    }
}

