/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jp.vmi.html.result.HtmlResult;
import jp.vmi.html.result.HtmlResultHolder;
import jp.vmi.junit.result.JUnitResult;
import jp.vmi.junit.result.JUnitResultHolder;
import jp.vmi.selenium.rollup.RollupRules;
import jp.vmi.selenium.selenese.CollectionMap;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.ErrorSource;
import jp.vmi.selenium.selenese.Eval;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Parser;
import jp.vmi.selenium.selenese.ScreenshotHandler;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.TestSuite;
import jp.vmi.selenium.selenese.VarsMap;
import jp.vmi.selenium.selenese.command.CommandFactory;
import jp.vmi.selenium.selenese.command.CommandListIterator;
import jp.vmi.selenium.selenese.highlight.HighlightHandler;
import jp.vmi.selenium.selenese.highlight.HighlightStyle;
import jp.vmi.selenium.selenese.highlight.HighlightStyleBackup;
import jp.vmi.selenium.selenese.inject.Binder;
import jp.vmi.selenium.selenese.locator.Locator;
import jp.vmi.selenium.selenese.locator.WebDriverElementFinder;
import jp.vmi.selenium.selenese.log.CookieFilter;
import jp.vmi.selenium.selenese.log.PageInformation;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Unexecuted;
import jp.vmi.selenium.selenese.subcommand.SubCommandMap;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.webdriver.WebDriverPreparator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runner
implements Context,
ScreenshotHandler,
HighlightHandler,
JUnitResultHolder,
HtmlResultHolder {
    private static final Logger log = LoggerFactory.getLogger(Runner.class);
    private static final FastDateFormat FILE_DATE_TIME = FastDateFormat.getInstance((String)"yyyyMMdd_HHmmssSSS");
    private static PrintStream DEFAULT_PRINT_STREAM = new PrintStream((OutputStream)new NullOutputStream());
    private PrintStream ps;
    private WebDriver driver = null;
    private WebDriverPreparator preparator = null;
    private String overridingBaseURL = null;
    private String initialWindowHandle = null;
    private String screenshotDir = null;
    private String screenshotAllDir = null;
    private String screenshotOnFailDir = null;
    private boolean isIgnoredScreenshotCommand = false;
    private boolean isHighlight = false;
    private int timeout = 30000;
    private long initialSpeed = 0L;
    private long speed = 0L;
    private final Eval eval;
    private final SubCommandMap subCommandMap;
    private final WebDriverElementFinder elementFinder;
    private final CommandFactory commandFactory;
    private TestCase currentTestCase = null;
    private final Deque<CommandListIterator> commandListIteratorStack = new ArrayDeque<CommandListIterator>();
    private VarsMap varsMap = new VarsMap();
    private final CollectionMap collectionMap = new CollectionMap();
    private RollupRules rollupRules = null;
    private final Deque<HighlightStyleBackup> styleBackups;
    private PageInformation latestPageInformation = PageInformation.EMPTY;
    private CookieFilter cookieFilter = CookieFilter.ALL_PASS;
    private final JUnitResult jUnitResult = new JUnitResult();
    private final HtmlResult htmlResult = new HtmlResult();

    public Runner() {
        this.ps = DEFAULT_PRINT_STREAM;
        this.eval = new Eval(this);
        this.elementFinder = new WebDriverElementFinder();
        this.subCommandMap = new SubCommandMap(this);
        this.commandFactory = new CommandFactory(this);
        this.varsMap = new VarsMap();
        this.styleBackups = new ArrayDeque<HighlightStyleBackup>();
    }

    public void setCommandLineArgs(String[] args) {
        this.jUnitResult.setCommandLineArgs(args);
        this.htmlResult.setCommandLineArgs(args);
    }

    @Override
    public TestCase getCurrentTestCase() {
        return this.currentTestCase;
    }

    @Override
    public void setCurrentTestCase(TestCase currentTestCase) {
        this.currentTestCase = currentTestCase;
    }

    public void setPrintStream(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    public PrintStream getPrintStream() {
        return this.ps;
    }

    private TakesScreenshot getTakesScreenshot() {
        if (this.driver instanceof TakesScreenshot) {
            return (TakesScreenshot)this.driver;
        }
        if (this.driver instanceof RemoteWebDriver && ((HasCapabilities)this.driver).getCapabilities().is("takesScreenshot")) {
            return (TakesScreenshot)new Augmenter().augment(this.driver);
        }
        return null;
    }

    private String takeScreenshot(TakesScreenshot tss, File file) throws WebDriverException {
        file = file.getAbsoluteFile();
        try {
            this.driver.switchTo().defaultContent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File tmp = (File)tss.getScreenshotAs(OutputType.FILE);
        try {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
                log.info("Make the directory for screenshot: {}", (Object)dir);
            }
            FileUtils.moveFile((File)tmp, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to rename captured screenshot image: " + file, e);
        }
        String path = file.getPath();
        log.info("- captured screenshot: {}", (Object)path);
        this.currentTestCase.getLogRecorder().info("[[ATTACHMENT|" + path + "]]");
        return path;
    }

    @Override
    public String takeScreenshot(String filename) throws WebDriverException, UnsupportedOperationException {
        TakesScreenshot tss = this.getTakesScreenshot();
        if (tss == null) {
            throw new UnsupportedOperationException("webdriver does not support capturing screenshot.");
        }
        File file = new File(PathUtils.normalize(filename));
        if (this.screenshotDir != null) {
            file = new File(this.screenshotDir, file.getName());
        }
        return this.takeScreenshot(tss, file);
    }

    @Override
    public String takeScreenshotAll(String prefix, int index) {
        if (this.screenshotAllDir == null) {
            return null;
        }
        TakesScreenshot tss = this.getTakesScreenshot();
        if (tss == null) {
            return null;
        }
        String filename = String.format("%s_%s_%d.png", prefix, FILE_DATE_TIME.format(Calendar.getInstance()), index);
        try {
            File file = new File(this.screenshotAllDir, filename);
            return this.takeScreenshot(tss, file);
        }
        catch (WebDriverException e) {
            log.warn("- failed to capture screenshot: {} - {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public String takeScreenshotOnFail(String prefix, int index) {
        if (this.screenshotOnFailDir == null) {
            return null;
        }
        TakesScreenshot tss = this.getTakesScreenshot();
        if (tss == null) {
            return null;
        }
        String filename = String.format("%s_%s_%d_fail.png", prefix, FILE_DATE_TIME.format(Calendar.getInstance()), index);
        try {
            File file = new File(this.screenshotOnFailDir, filename);
            return this.takeScreenshot(tss, file);
        }
        catch (WebDriverException e) {
            log.warn("- failed to capture screenshot: {} - {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
    }

    @Deprecated
    public WebDriver getDriver() {
        return this.getWrappedDriver();
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    @Override
    public String getInitialWindowHandle() {
        return this.initialWindowHandle;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
        this.initialWindowHandle = driver.getWindowHandle();
        this.setDriverTimeout();
    }

    @Override
    public void prepareWebDriver() {
        if (this.preparator == null) {
            return;
        }
        this.setDriver((WebDriver)this.preparator.get());
    }

    public void setWebDriverPreparator(WebDriverPreparator preparator) {
        this.preparator = preparator;
    }

    private static void mkdirsForScreenshot(String dirStr, String msg) {
        if (dirStr == null) {
            return;
        }
        File dir = new File(dirStr);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return;
            }
            throw new IllegalArgumentException(dirStr + " is not directory.");
        }
        dir.mkdirs();
        log.info("Make the directory for {}: {}", (Object)msg, (Object)dirStr);
    }

    public void setScreenshotDir(String screenshotDir) throws IllegalArgumentException {
        Runner.mkdirsForScreenshot(screenshotDir, "screenshot");
        this.screenshotDir = screenshotDir;
        log.info("Screenshot directory: {}", (Object)StringUtils.defaultString((String)screenshotDir, (String)"-"));
    }

    public void setScreenshotAllDir(String screenshotAllDir) throws IllegalArgumentException {
        Runner.mkdirsForScreenshot(screenshotAllDir, "screenshot-all");
        this.screenshotAllDir = screenshotAllDir;
        log.info("Screenshot for all commands directory: {}", (Object)StringUtils.defaultString((String)screenshotAllDir, (String)"-"));
    }

    public void setScreenshotOnFailDir(String screenshotOnFailDir) {
        Runner.mkdirsForScreenshot(screenshotOnFailDir, "screenshot-on-fail");
        this.screenshotOnFailDir = screenshotOnFailDir;
        log.info("Screenshot on fail directory: {}", (Object)StringUtils.defaultString((String)screenshotOnFailDir, (String)"-"));
    }

    @Deprecated
    public String getBaseURL() {
        return this.getCurrentBaseURL();
    }

    @Deprecated
    public void setBaseURL(String baseURL) {
        this.setOverridingBaseURL(baseURL);
    }

    @Override
    public String getCurrentBaseURL() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.overridingBaseURL, (CharSequence)this.currentTestCase.getBaseURL());
    }

    public void setOverridingBaseURL(String overridingBaseURL) {
        this.overridingBaseURL = overridingBaseURL;
        log.info("Override base URL: {}", (Object)overridingBaseURL);
    }

    @Override
    public String getOverridingBaseURL() {
        return this.overridingBaseURL;
    }

    @Deprecated
    public void setIgnoreScreenshotCommand(boolean isIgnoredScreenshotCommand) {
        this.setIgnoredScreenshotCommand(isIgnoredScreenshotCommand);
    }

    public void setIgnoredScreenshotCommand(boolean isIgnoredScreenshotCommand) {
        this.isIgnoredScreenshotCommand = isIgnoredScreenshotCommand;
        log.info("Screenshot command: {}", (Object)(isIgnoredScreenshotCommand ? "ignored" : "enabled"));
    }

    @Deprecated
    public boolean isIgnoreScreenshotCommand() {
        return this.isIgnoredScreenshotCommand();
    }

    @Override
    public boolean isIgnoredScreenshotCommand() {
        return this.isIgnoredScreenshotCommand;
    }

    @Override
    public boolean isHighlight() {
        return this.isHighlight;
    }

    public void setHighlight(boolean isHighlight) {
        this.isHighlight = isHighlight;
        log.info("Highlight mode: {}", (Object)(isHighlight ? "enabled" : "disabled"));
    }

    private void setDriverTimeout() {
        this.driver.manage().timeouts().pageLoadTimeout((long)this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
        if (this.driver != null) {
            this.setDriverTimeout();
        }
        log.info("Timeout: {} ms", (Object)timeout);
    }

    public long getInitialSpeed() {
        return this.initialSpeed;
    }

    public void setInitialSpeed(long initialSpeed) {
        this.initialSpeed = initialSpeed;
    }

    @Override
    public void resetSpeed() {
        this.speed = this.initialSpeed;
        log.info("Current speed: {} ms/command", (Object)this.speed);
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(long speed) {
        this.speed = speed;
        log.info("Current speed: {} ms/command", (Object)speed);
    }

    @Override
    public void waitSpeed() {
        if (this.speed > 0L) {
            try {
                Thread.sleep(this.speed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public SubCommandMap getSubCommandMap() {
        return this.subCommandMap;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Override
    public CommandListIterator getCommandListIterator() {
        return this.commandListIteratorStack.peekFirst();
    }

    @Override
    public void pushCommandListIterator(CommandListIterator commandListIterator) {
        this.commandListIteratorStack.push(commandListIterator);
    }

    @Override
    public void popCommandListIterator() {
        this.commandListIteratorStack.pop();
    }

    @Override
    public VarsMap getVarsMap() {
        return this.varsMap;
    }

    public void setVarsMap(VarsMap varsMap) {
        this.varsMap = varsMap;
    }

    @Override
    public CollectionMap getCollectionMap() {
        return this.collectionMap;
    }

    @Override
    public RollupRules getRollupRules() {
        if (this.rollupRules == null) {
            this.rollupRules = new RollupRules();
        }
        return this.rollupRules;
    }

    @Override
    public Eval getEval() {
        return this.eval;
    }

    @Override
    public WebDriverElementFinder getElementFinder() {
        return this.elementFinder;
    }

    @Override
    public PageInformation getLatestPageInformation() {
        return this.latestPageInformation;
    }

    @Override
    public void setLatestPageInformation(PageInformation pageInformation) {
        this.latestPageInformation = pageInformation;
    }

    @Override
    public CookieFilter getCookieFilter() {
        return this.cookieFilter;
    }

    @Override
    public void setCookieFilter(CookieFilter cookieFilter) {
        this.cookieFilter = cookieFilter;
    }

    public Result execute(Selenese selenese) {
        try {
            return selenese.execute(null, this);
        }
        catch (InvalidSeleneseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isTrue(String expr) {
        return (Boolean)this.eval.eval(this.driver, this.varsMap.replaceVars(expr), "Boolean");
    }

    public Result run(String ... filenames) {
        Result totalResult = Unexecuted.UNEXECUTED;
        ArrayList<TestSuite> testSuiteList = new ArrayList<TestSuite>();
        block6: for (String filename : filenames) {
            Selenese selenese = Parser.parse(filename, this.commandFactory);
            Parser.setContextForBackwardCompatibility(selenese, this);
            if (selenese.isError()) {
                log.error(selenese.toString());
                totalResult = ((ErrorSource)selenese).getResult();
                continue;
            }
            switch (selenese.getType()) {
                case TEST_SUITE: {
                    testSuiteList.add((TestSuite)selenese);
                    continue block6;
                }
                case TEST_CASE: {
                    TestSuite testSuite = Binder.newTestSuite(filename, selenese.getName());
                    testSuite.addSelenese(selenese);
                    testSuiteList.add(testSuite);
                }
            }
        }
        if (totalResult != Unexecuted.UNEXECUTED) {
            return totalResult;
        }
        for (TestSuite testSuite : testSuiteList) {
            Result result;
            try {
                result = this.execute(testSuite);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage());
                throw e;
            }
            totalResult = totalResult.update(result);
        }
        return totalResult;
    }

    public Result run(String filename, InputStream is) {
        TestSuite testSuite;
        Selenese selenese = Parser.parse(filename, is, this.commandFactory);
        Parser.setContextForBackwardCompatibility(selenese, this);
        switch (selenese.getType()) {
            case TEST_CASE: {
                testSuite = Binder.newTestSuite(filename, selenese.getName());
                testSuite.addSelenese(selenese);
                break;
            }
            case TEST_SUITE: {
                testSuite = (TestSuite)selenese;
                break;
            }
            default: {
                throw new RuntimeException("Unknown Selenese object: " + selenese);
            }
        }
        return testSuite.execute(null, this);
    }

    public void setJUnitResultDir(String dir) {
        this.jUnitResult.setDir(dir);
        log.info("JUnit result directory: {}", (Object)dir);
    }

    @Override
    public JUnitResult getJUnitResult() {
        return this.jUnitResult;
    }

    public void setHtmlResultDir(String dir) {
        this.htmlResult.setDir(dir);
        log.info("HTML result directory: {}", (Object)dir);
    }

    @Override
    public HtmlResult getHtmlResult() {
        return this.htmlResult;
    }

    public void finish() {
        this.jUnitResult.generateFailsafeSummary();
        this.htmlResult.generateIndex();
    }

    @Override
    public void highlight(String locator, HighlightStyle highlightStyle) {
        List<Locator> selectedFrameLocators = this.elementFinder.getCurrentFrameLocators();
        Map<String, String> prevStyles = highlightStyle.doHighlight(this.driver, this.elementFinder, locator, selectedFrameLocators);
        if (prevStyles == null) {
            return;
        }
        HighlightStyleBackup backup = new HighlightStyleBackup(prevStyles, locator, selectedFrameLocators);
        this.styleBackups.push(backup);
    }

    @Override
    public void unhighlight() {
        while (!this.styleBackups.isEmpty()) {
            HighlightStyleBackup backup = this.styleBackups.pop();
            backup.restore(this.driver, this.elementFinder);
        }
    }
}

