/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.thoughtworks.selenium.SeleniumException;
import java.util.ListIterator;
import jp.vmi.selenium.selenese.command.CommandList;
import jp.vmi.selenium.selenese.command.CommandSequence;
import jp.vmi.selenium.selenese.command.ICommand;

public class CommandListIterator
implements ListIterator<ICommand> {
    private final CommandList commandList;
    private ListIterator<ICommand> iterator;
    private final CommandSequence commandSequence;

    CommandListIterator(CommandList commandList, CommandListIterator parentIterator) {
        this.commandList = commandList;
        this.iterator = commandList.originalListIterator(0);
        this.commandSequence = new CommandSequence(parentIterator != null ? parentIterator.getCommandSequence() : null);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ICommand next() {
        return this.iterator.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    @Override
    public ICommand previous() {
        return this.iterator.previous();
    }

    @Override
    public int nextIndex() {
        return this.iterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.iterator.previousIndex();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(ICommand e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(ICommand e) {
        throw new UnsupportedOperationException();
    }

    public void jumpTo(Object key) {
        int index;
        if (key == null) {
            index = this.commandList.size();
        } else {
            index = this.commandList.indexOf(key);
            if (index == -1) {
                throw new SeleniumException("Cannot jump to " + key);
            }
        }
        this.iterator = this.commandList.originalListIterator(index);
    }

    public void jumpToNextOf(Object key) {
        int index;
        if (key == null) {
            index = this.commandList.size();
        } else {
            index = this.commandList.indexOf(key);
            if (index == -1) {
                throw new SeleniumException("Cannot jump to next of " + key);
            }
            ++index;
        }
        this.iterator = this.commandList.originalListIterator(index);
    }

    public CommandSequence getCommandSequence() {
        return this.commandSequence;
    }
}

