/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.utils.Wait;
import jp.vmi.selenium.selenese.utils.WindowSelector;

public class WaitForPopUp
extends AbstractCommand {
    private static final int ARG_WINDOW_ID = 0;
    private static final int ARG_TIMEOUT = 1;

    WaitForPopUp(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE, ArgumentType.VALUE);
    }

    @Override
    protected Result executeImpl(final Context context, String ... curArgs) {
        String[] selectedHandle;
        final String windowID = curArgs[0];
        String argTimeout = curArgs[1];
        long timeout = argTimeout == null || argTimeout.isEmpty() ? (long)context.getTimeout() : Long.valueOf(argTimeout);
        long startTime = System.currentTimeMillis();
        boolean result = Wait.defaultInterval.wait(startTime, timeout, new Wait.StopCondition(selectedHandle = new String[1]){
            final /* synthetic */ String[] val$selectedHandle;
            {
                this.val$selectedHandle = stringArray;
            }

            @Override
            public boolean isSatisfied() {
                String handle = WindowSelector.getInstance().selectPopUp(context, windowID);
                if (handle == null) {
                    return false;
                }
                this.val$selectedHandle[0] = handle;
                return true;
            }
        });
        if (!result) {
            return new Error("Specified pop up window not found: " + windowID);
        }
        String title = context.getWrappedDriver().getTitle();
        return new Success("Selected pop up window [" + selectedHandle[0] + "] " + title);
    }
}

