/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EscapeUtils {
    public static final Pattern HTML_RE = Pattern.compile("([<>&\"'\\\\])|\r?\n|\r");
    public static final Map<String, String> HTML_ESC_MAP = new HashMap<String, String>();
    public static Pattern URI_RE;

    private EscapeUtils() {
    }

    public static String escapeHtml(String s, boolean newline) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = HTML_RE.matcher(s);
        int index = 0;
        while (matcher.find(index)) {
            int start = matcher.start();
            if (index < start) {
                result.append(s, index, start);
            }
            if (newline) {
                result.append(HTML_ESC_MAP.get(matcher.group()));
            } else {
                String specials = matcher.group(1);
                if (specials != null) {
                    result.append(HTML_ESC_MAP.get(specials));
                } else {
                    result.append('\n');
                }
            }
            index = matcher.end();
        }
        if (index < s.length()) {
            result.append(s, index, s.length());
        }
        return result.toString();
    }

    public static String encodeUri(String s) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = URI_RE.matcher(s);
        int index = 0;
        while (matcher.find(index)) {
            int start = matcher.start();
            if (index < start) {
                result.append(s, index, start);
            }
            for (byte b : matcher.group().getBytes(StandardCharsets.UTF_8)) {
                result.append(String.format("%%%02x", b));
            }
            index = matcher.end();
        }
        if (index < s.length()) {
            result.append(s, index, s.length());
        }
        return result.toString();
    }

    static {
        HTML_ESC_MAP.put("<", "&lt;");
        HTML_ESC_MAP.put(">", "&gt;");
        HTML_ESC_MAP.put("&", "&amp;");
        HTML_ESC_MAP.put("\"", "&quot;");
        HTML_ESC_MAP.put("'", "&#39;");
        HTML_ESC_MAP.put("\\", "&#92;");
        HTML_ESC_MAP.put("\r\n", "<br>\n");
        HTML_ESC_MAP.put("\n", "<br>\n");
        HTML_ESC_MAP.put("\r", "<br>\n");
        URI_RE = Pattern.compile("[^;,/?:@&=+$A-Za-z0-9\\-_.!~*'()#]+");
    }
}

