/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.runner.model.side;

import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jp.vmi.selenium.runner.model.IProject;
import jp.vmi.selenium.runner.model.side.SideCommand;
import jp.vmi.selenium.runner.model.side.SideFile;
import jp.vmi.selenium.runner.model.side.SideSuite;
import jp.vmi.selenium.runner.model.side.SideTest;

public class SideProject
implements IProject<SideSuite, SideTest, SideCommand> {
    private final String filename;
    private final String name;
    private final String id;
    private final String url;
    private final List<SideSuite> suites;
    private final Map<String, SideSuite> suiteMap = new HashMap<String, SideSuite>();
    private final Map<String, SideTest> testMap = new HashMap<String, SideTest>();

    SideProject(String filename, SideFile sideFile) {
        this.filename = filename;
        this.name = sideFile.getName();
        this.id = sideFile.getId();
        this.url = sideFile.getUrl();
        this.suites = sideFile.getSuites();
        sideFile.getTests().stream().forEach(test -> this.testMap.put(test.getId(), (SideTest)test));
        this.suites.stream().forEach(suite -> {
            ListIterator<SideTest> iter = suite.getTests().listIterator();
            while (iter.hasNext()) {
                SideTest unresolved = iter.next();
                SideTest resolved = this.testMap.get(unresolved.getId());
                iter.set(resolved);
            }
            this.suiteMap.put(suite.getId(), (SideSuite)suite);
        });
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public List<SideSuite> getSuites() {
        return this.suites;
    }

    @Override
    public Map<String, SideSuite> getSuiteMap() {
        return this.suiteMap;
    }

    @Override
    public Map<String, SideTest> getTestMap() {
        return this.testMap;
    }

    public static String toJson(Object object) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(object);
    }
}

