/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.selenese.utils.StopWatch;
import org.apache.commons.io.FilenameUtils;

public abstract class ErrorSource
implements Selenese {
    private String filename;
    private String baseName;
    private InvalidSeleneseException e;
    private final StopWatch stopWatch = new StopWatch();

    public ErrorSource initialize(String filename, InvalidSeleneseException e) {
        this.filename = PathUtils.normalize(filename);
        this.baseName = FilenameUtils.getBaseName((String)filename);
        this.e = e;
        return this;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public String getName() {
        return FilenameUtils.getBaseName((String)this.filename);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    @Override
    public Result execute(Selenese parent, Context context) throws InvalidSeleneseException {
        throw this.e;
    }

    @Override
    public Result getResult() {
        return new Error(this.e);
    }

    public String toString() {
        String name = this.getClass().getSimpleName().replaceFirst("\\$\\$.*$", "");
        return String.format("%s[%s] %s", name, this.filename, this.e.getMessage());
    }
}

