/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jp.vmi.selenium.selenese.TestCase;

public class TestCaseMap
extends AbstractMap<String, TestCase> {
    public static final TestCaseMap EMPTY = new TestCaseMap(false);
    private final Map<String, TestCase> nameMap;
    private final Map<String, TestCase> idMap;

    public TestCaseMap() {
        this(true);
    }

    private TestCaseMap(boolean isWritable) {
        if (isWritable) {
            this.nameMap = new LinkedHashMap<String, TestCase>();
            this.idMap = new LinkedHashMap<String, TestCase>();
        } else {
            this.nameMap = Collections.emptyMap();
            this.idMap = Collections.emptyMap();
        }
    }

    public void put(TestCase testCase) {
        String name = testCase.getName();
        String id = testCase.getId();
        this.nameMap.put(name, testCase);
        this.idMap.put(id, testCase);
    }

    @Override
    public TestCase put(String name, TestCase testCase) {
        TestCase result = this.nameMap.put(name, testCase);
        this.idMap.put(testCase.getId(), testCase);
        return result;
    }

    public TestCase getById(String id) {
        return this.idMap.get(id);
    }

    @Override
    public Set<Map.Entry<String, TestCase>> entrySet() {
        return this.nameMap.entrySet();
    }
}

