/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.SourceType;
import jp.vmi.selenium.selenese.TestCaseParser;
import jp.vmi.selenium.selenese.TestSuite;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.Binder;
import jp.vmi.selenium.selenese.parser.CommandIterator;
import jp.vmi.selenium.selenese.parser.TestCaseEntry;
import jp.vmi.selenium.selenese.parser.TestCaseIterator;
import jp.vmi.selenium.selenese.parser.TestElementIteratorFactory;
import jp.vmi.selenium.selenese.parser.TestProjectReader;

public final class TestSuiteParser {
    public static Selenese parse(SourceType sourceType, TestCaseIterator caseIter, TestProjectReader projectReader, ICommandFactory commandFactory) {
        TestSuite testSuite = Binder.newTestSuite(caseIter.getFilename(), caseIter.getName());
        testSuite.setId(caseIter.getId());
        try {
            TestElementIteratorFactory<CommandIterator, TestCaseEntry> comIterFactory = caseIter.getCommandIteratorFactory();
            for (TestCaseEntry entry : caseIter) {
                CommandIterator comIter = comIterFactory.getTestElementIterator(entry);
                Selenese selenese = TestCaseParser.parse(sourceType, comIter, projectReader, commandFactory);
                testSuite.addSelenese(selenese);
            }
        }
        catch (InvalidSeleneseException e) {
            testSuite.addSelenese(Binder.newErrorTestCase(e.getFilename(), e));
        }
        return caseIter.isDummy() ? testSuite.getSeleneseList().get(0) : testSuite;
    }
}

