/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.result.Warning;
import org.apache.commons.io.FilenameUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.io.TemporaryFilesystem;

public class AttachFile
extends AbstractCommand {
    private static final int ARG_LOCATOR = 0;
    private static final int ARG_FILENAME = 1;

    AttachFile(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR, ArgumentType.VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String name = curArgs[1];
        File outputTo = null;
        if (name.contains("://")) {
            URL url;
            try {
                url = new URL(name);
            }
            catch (MalformedURLException e) {
                return new Error("Malformed URL: " + name);
            }
            File dir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("attachFile", "dir");
            outputTo = new File(dir, new File(url.getFile()).getName());
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outputTo);
                Resources.copy((URL)url, (OutputStream)fos);
            }
            catch (IOException e) {
                Error error = new Error("Can't access file to upload: " + url, e);
                return error;
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    return new Warning("Unable to close stream used for reading file: " + name, e);
                }
            }
        }
        outputTo = new File(FilenameUtils.getPath((String)context.getCurrentTestCase().getFilename()), name);
        if (!outputTo.exists()) {
            return new Error("Can't access file: " + outputTo);
        }
        WebElement element = context.findElement(curArgs[0]);
        try {
            element.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        element.sendKeys(new CharSequence[]{outputTo.getAbsolutePath()});
        return Success.SUCCESS;
    }
}

