/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jp.vmi.selenium.selenese.command.BlockEnd;
import jp.vmi.selenium.selenese.command.BlockStart;
import jp.vmi.selenium.selenese.command.ICommand;

public class CommandSequence {
    private static final char SEPARATOR = '-';
    private final CommandSequence parent;
    private final List<Counter> counters = new ArrayList<Counter>();
    private Counter tail;

    public CommandSequence(CommandSequence parent) {
        this.parent = parent;
        this.tail = new Counter(BlockStart.NO_BLOCK_START, 0);
        this.counters.add(this.tail);
    }

    private static List<BlockStart> getListOfBlockStart(ICommand command) {
        BlockStart blockStart = command.getBlockStart();
        while (blockStart instanceof BlockEnd) {
            blockStart = ((ICommand)((Object)blockStart)).getBlockStart();
        }
        List<Object> result = blockStart == BlockStart.NO_BLOCK_START ? new ArrayList() : CommandSequence.getListOfBlockStart((ICommand)((Object)blockStart));
        result.add(blockStart);
        return result;
    }

    public void increment(ICommand command) {
        if (this.tail.blockStart == command.getBlockStart()) {
            ++this.tail.count;
        } else {
            Iterator<Counter> citer = this.counters.iterator();
            ListIterator<BlockStart> siter = CommandSequence.getListOfBlockStart(command).listIterator();
            int index = 0;
            while (citer.hasNext() && siter.hasNext()) {
                if (citer.next().blockStart != siter.next()) {
                    siter.previous();
                    break;
                }
                ++index;
            }
            if (index < this.counters.size()) {
                this.counters.subList(index, this.counters.size()).clear();
            }
            ++this.counters.get((int)(this.counters.size() - 1)).count;
            while (siter.hasNext()) {
                BlockStart s = siter.next();
                this.counters.add(new Counter(s, 1));
            }
            this.tail = this.counters.get(this.counters.size() - 1);
        }
        if (command instanceof BlockStart && !(command instanceof BlockEnd)) {
            this.tail = new Counter((BlockStart)((Object)command), 1);
            this.counters.add(this.tail);
        }
    }

    public int getLevel() {
        return (this.parent != null ? this.parent.getLevel() : 0) + this.counters.size();
    }

    private StringBuilder appendString(StringBuilder result) {
        if (result.length() > 0) {
            result.append('-');
        }
        Iterator<Counter> iter = this.counters.iterator();
        result.append(iter.next().count);
        while (iter.hasNext()) {
            result.append('-').append(iter.next().count);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getLevel() * 4);
        if (this.parent != null) {
            this.parent.appendString(result);
        }
        return this.appendString(result).toString();
    }

    private static class Counter {
        public BlockStart blockStart;
        public int count;

        public Counter(BlockStart blockStart, int count) {
            this.blockStart = blockStart;
            this.count = count;
        }
    }
}

