/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.Iterator;
import java.util.List;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.FlowControlState;
import jp.vmi.selenium.selenese.VarsMap;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.command.BlockStartImpl;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;

public class ForEach
extends BlockStartImpl {
    private static final int ARG_ARRAY_VAR = 0;
    private static final int ARG_ITER_VAR = 1;

    ForEach(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE, ArgumentType.VALUE);
    }

    @Override
    public boolean isLoopBlock() {
        return true;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        Object value;
        VarsMap varsMap = context.getVarsMap();
        ForEachState state = (ForEachState)context.getFlowControlState(this);
        if (state == null) {
            String arrayVar = curArgs[0];
            value = varsMap.get(arrayVar);
            if (value == null || !(value instanceof List)) {
                return new Error(String.format("%s is not array: %s", arrayVar, value));
            }
            List array = (List)value;
            state = new ForEachState(array);
            context.setFlowControlState(this, state);
        }
        String iterVar = curArgs[1];
        if (state.hasNext()) {
            value = state.next();
            varsMap.put(iterVar, value);
            int count = state.getCount();
            int maxCount = state.getMaxCount();
            return new Success(String.format("Continue (%d/%d: %s=%s)", count, maxCount, iterVar, value));
        }
        context.getCommandListIterator().jumpTo(this.blockEnd);
        return new Success("Break");
    }

    private static class ForEachState
    implements FlowControlState,
    Iterator<Object> {
        private int count = 0;
        private final int maxCount;
        private final Iterator<Object> iter;

        ForEachState(List<Object> array) {
            this.maxCount = array.size();
            this.iter = array.iterator();
        }

        @Override
        public boolean isAlreadyFinished() {
            return !this.hasNext();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Object next() {
            ++this.count;
            return this.iter.next();
        }

        int getCount() {
            return this.count;
        }

        int getMaxCount() {
            return this.maxCount;
        }
    }
}

