/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.locator.OptionLocator;
import jp.vmi.selenium.selenese.locator.WebDriverElementFinder;
import jp.vmi.selenium.selenese.result.Failure;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class SelectElement {
    private final WebDriverElementFinder finder;
    private final WebElement select;
    private final Select selectUI;
    public final boolean isMultiple;

    public SelectElement(Context context, String selectLocator) {
        WebDriver driver = context.getWrappedDriver();
        this.finder = context.getElementFinder();
        this.select = this.finder.findElement(driver, selectLocator);
        context.getJSLibrary().replaceAlertMethod(driver, this.select);
        this.selectUI = new Select(this.select);
        this.isMultiple = this.selectUI.isMultiple();
    }

    public void unsetOptions() {
        this.selectUI.deselectAll();
    }

    public Result selectOptions(String optionLocator, boolean selectOrDeselect) {
        try {
            OptionLocator oLoc = new OptionLocator(optionLocator);
            switch (oLoc.type) {
                case "label": {
                    if (selectOrDeselect) {
                        this.selectUI.selectByVisibleText(oLoc.arg);
                        break;
                    }
                    this.selectUI.deselectByVisibleText(oLoc.arg);
                    break;
                }
                case "value": {
                    if (selectOrDeselect) {
                        this.selectUI.selectByValue(oLoc.arg);
                        break;
                    }
                    this.selectUI.deselectByValue(oLoc.arg);
                    break;
                }
                case "id": {
                    WebElement option = this.select.findElement(By.id((String)oLoc.arg));
                    if (!(option.isSelected() ^ selectOrDeselect)) break;
                    option.click();
                    break;
                }
                case "index": {
                    int index = Integer.parseInt(oLoc.arg);
                    if (selectOrDeselect) {
                        this.selectUI.selectByIndex(index);
                        break;
                    }
                    this.selectUI.deselectByIndex(index);
                }
            }
        }
        catch (NoSuchElementException e) {
            String msg = e.getMessage();
            int nlIndex = msg.indexOf(10);
            if (nlIndex > 0) {
                if (msg.charAt(nlIndex - 1) == '\r') {
                    --nlIndex;
                }
                msg = msg.substring(0, nlIndex);
            }
            return new Failure(msg);
        }
        return Success.SUCCESS;
    }
}

