/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.openqa.selenium.WebElement;

public class SetCursorPosition
extends AbstractCommand {
    private static final int ARG_LOCATOR = 0;
    private static final int ARG_POSITION = 0;

    SetCursorPosition(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR, ArgumentType.VALUE);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        int position;
        WebElement element = context.findElement(curArgs[0]);
        try {
            position = Integer.parseInt(curArgs[0]);
        }
        catch (NumberFormatException e) {
            return new Error("Position is not a number: " + curArgs[0]);
        }
        context.getJSLibrary().setCursorPosition(context.getWrappedDriver(), element, position);
        return Success.SUCCESS;
    }
}

