/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.FlowControlState;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.command.BlockStartImpl;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;

public class While
extends BlockStartImpl {
    private static final int ARG_CONDITION = 0;
    private static final int ARG_LOOP_LIMIT = 1;
    private static final String LOOP_LIMIT_MESSAGE = "Max retry limit exceeded (count=%d/limit=%d). To override it, specify a new limit in the value input field";

    While(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE, ArgumentType.VALUE);
    }

    @Override
    public boolean isLoopBlock() {
        return true;
    }

    private static long getLongValue(Context context, String s) {
        return ((Number)context.executeScript("return (" + s + ")", new Object[0])).longValue();
    }

    private static long getLoopLimit(Context context, String[] args, int index) {
        if (index >= args.length) {
            return Long.MAX_VALUE;
        }
        String s = args[index];
        if (s == null || s.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return While.getLongValue(context, s);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        long loopLimit = While.getLoopLimit(context, curArgs, 1);
        WhileState state = (WhileState)context.getFlowControlState(this);
        if (state == null) {
            state = new WhileState();
            context.setFlowControlState(this, state);
        }
        state.incrementCount();
        if (state.hasReachedLoopLimit(loopLimit)) {
            return new Error(String.format(LOOP_LIMIT_MESSAGE, state.getCount(), loopLimit));
        }
        if (!context.isTrue(curArgs[0])) {
            state.setAlreadyFinished(true);
            context.getCommandListIterator().jumpTo(this.blockEnd);
            return new Success("Break");
        }
        String msg = loopLimit != Long.MAX_VALUE ? String.format("Continue (count=%d/limit=%d)", state.getCount(), loopLimit) : String.format("Continue (count=%d)", state.getCount());
        return new Success(msg);
    }

    private static class WhileState
    implements FlowControlState {
        private boolean isAlreadyFinished = false;
        private long count = 0L;

        private WhileState() {
        }

        void incrementCount() {
            ++this.count;
        }

        long getCount() {
            return this.count;
        }

        @Override
        public boolean isAlreadyFinished() {
            return this.isAlreadyFinished;
        }

        public void setAlreadyFinished(boolean isAlreadyFinished) {
            this.isAlreadyFinished = isAlreadyFinished;
        }

        boolean hasReachedLoopLimit(long loopLimit) {
            if (this.isAlreadyFinished || loopLimit == Long.MAX_VALUE) {
                return false;
            }
            return this.count > loopLimit;
        }
    }
}

