/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.config;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.config.IConfig;
import jp.vmi.selenium.selenese.config.OptionMap;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.LangUtils;
import jp.vmi.selenium.selenese.utils.SystemInformation;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.text.WordUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.ParserProperties;

public class DefaultConfig
implements IConfig {
    public static final int HELP_WIDTH = 80;
    public static final int HELP_PADDING = 2;
    public static final int DEFAULT_TIMEOUT_MILLISEC_N = 30000;
    public static final String DEFAULT_TIMEOUT_MILLISEC = Integer.toString(30000);
    public static final int DEFAULT_MAX_RETRIES = 0;
    private static final String[] HEADER = new String[]{"Selenese script interpreter implemented by Java.", "", "Usage: java -jar selenese-runner.jar <option> ... <test-case|test-suite> ..."};
    private static final String[] FOOTER = new String[]{"[Note]", "*1 It is available if using \"--driver remote --remote-browser firefox\".", "", "*2 If you want to use basic and/or proxy authentication on Firefox, then create new profile, install AutoAuth plugin, configure all settings, access test site with the profile, and specify the profile by --profile option.", "", "*3 Use \"java -cp ..." + File.pathSeparator + "selenese-runner.jar Main --command-factory ...\". ", "Because \"java\" command ignores all class path settings, when using \"-jar\" option.", "", "*4 The list of exit code (strict/normal) is follows:", DefaultConfig.statusListItem(Result.Level.SUCCESS), DefaultConfig.statusListItem(Result.Level.WARNING), DefaultConfig.statusListItem(Result.Level.FAILURE), DefaultConfig.statusListItem(Result.Level.ERROR), DefaultConfig.statusListItem(Result.Level.UNEXECUTED), DefaultConfig.statusListItem(Result.Level.MAX_TIME_EXCEEDED), DefaultConfig.statusListItem(Result.Level.FATAL), DefaultConfig.statusListItem(Result.Level.USAGE)};
    private final CmdLineParser parser;
    private final int helpWidth;
    private IConfig parentOptions = null;
    @Option(name="--config", aliases={"-c"}, metaVar="<file>", usage="load option information from file.")
    private String config;
    @Option(name="--driver", aliases={"-d"}, metaVar="<driver>", usage="firefox (default) | chrome | ie | edge | safari | htmlunit | phantomjs | remote | appium | FQCN-of-WebDriverFactory")
    private String driver;
    @Option(name="--headless", usage="use headless mode if driver is supported (currently, Chrome and Firefox)")
    private Boolean headless;
    @Option(name="--profile", aliases={"-p"}, metaVar="<name>", usage="profile name (Firefox only *1)")
    private String profile;
    @Option(name="--profile-dir", aliases={"-P"}, metaVar="<dir>", usage="profile directory (Firefox only *1)")
    private String profileDir;
    @Option(name="--chrome-experimental-options", metaVar="<file>", usage="path to json file specify experimental options for chrome (Chrome only *1)")
    private String chromeExperimentalOptions;
    @Option(name="--chrome-extension", metaVar="<file>", usage="chrome extension file (multiple, Chrome only *1)")
    private String[] chromeExtension;
    @Option(name="--proxy-type", metaVar="<proxy-type>", usage="proxy type (manual (default if set --proxy) | pac | autodetect | system)")
    private String proxyType;
    @Option(name="--proxy", metaVar="<proxy>", usage="[manual] proxy host and port (HOST:PORT) (excepting IE) / [pac] PAC URL")
    private String proxy;
    @Option(name="--proxy-user", metaVar="<user>", usage="proxy username (HtmlUnit only *2)")
    private String proxyUser;
    @Option(name="--proxy-password", metaVar="<password>", usage="proxy password (HtmlUnit only *2)")
    private String proxyPassword;
    @Option(name="--no-proxy", metaVar="<hosts>", usage="no-proxy hosts")
    private String noProxy;
    @Option(name="--cli-args", metaVar="<arg>", usage="add command line arguments at starting up driver (multiple)")
    private String[] cliArgs;
    @Option(name="--remote-url", metaVar="<url>", usage="Remote test runner URL (Remote only)")
    private String remoteUrl;
    @Option(name="--remote-platform", metaVar="<platform>", usage="Desired remote platform (Remote only)")
    private String remotePlatform;
    @Option(name="--remote-browser", metaVar="<browser>", usage="Desired remote browser (Remote only)")
    private String remoteBrowser;
    @Option(name="--remote-version", metaVar="<browser-version>", usage="Desired remote browser version (Remote only)")
    private String remoteVersion;
    @Option(name="--highlight", aliases={"-H"}, usage="highlight locator always.")
    private Boolean highlight;
    @Option(name="--interactive", aliases={"-i"}, usage="interactive mode.")
    private Boolean interactive;
    @Option(name="--screenshot-dir", aliases={"-s"}, metaVar="<dir>", usage="override captureEntirePageScreenshot directory.")
    private String screenshotDir;
    @Option(name="--screenshot-all", aliases={"-S"}, metaVar="<dir>", usage="take screenshot at all commands to specified directory.")
    private String screenshotAll;
    @Option(name="--screenshot-on-fail", metaVar="<dir>", usage="take screenshot on fail commands to specified directory.")
    private String screenshotOnFail;
    @Option(name="--ignore-screenshot-command", usage="ignore captureEntirePageScreenshot command.")
    private Boolean ignoreScreenshotCommand;
    @Option(name="--baseurl", aliases={"-b"}, metaVar="<baseURL>", usage="override base URL set in selenese.")
    private String baseurl;
    @Option(name="--firefox", metaVar="<path>", usage="path to 'firefox' binary. (implies '--driver firefox')")
    private String firefox;
    @Option(name="--geckodriver", metaVar="<path>", usage="path to 'geckodriver' binary. (implies '--driver firefox')")
    private String geckodriver;
    @Option(name="--chromedriver", metaVar="<path>", usage="path to 'chromedriver' binary. (implies '--driver chrome')")
    private String chromedriver;
    @Option(name="--iedriver", metaVar="<path>", usage="path to 'IEDriverServer' binary. (implies '--driver ie')")
    private String iedriver;
    @Option(name="--edgedriver", metaVar="<path>", usage="path to Edge 'WebDriver' binary. (implies '--driver edge')")
    private String edgedriver;
    @Option(name="--phantomjs", metaVar="<path>", usage="path to 'phantomjs' binary. (implies '--driver phantomjs')")
    private String phantomjs;
    @Option(name="--xml-result", metaVar="<dir>", usage="output XML JUnit results to specified directory.")
    private String xmlResult;
    @Option(name="--html-result", metaVar="<dir>", usage="output HTML results to specified directory.")
    private String htmlResult;
    @Option(name="--timeout", aliases={"-t"}, metaVar="<timeout>", usage="set timeout (ms) for waiting. (default: 30000 ms)")
    private String timeout;
    @Option(name="--max-retries", metaVar="<maxRetries>", usage="set maximum number of retries for a given step. (default: 0)")
    private String maxRetries;
    @Option(name="--set-speed", metaVar="<speed>", usage="same as executing setSpeed(ms) command first.")
    private String setSpeed;
    @Option(name="--height", metaVar="<height>", usage="set initial height. (excluding mobile)")
    private String height;
    @Option(name="--width", metaVar="<width>", usage="set initial width. (excluding mobile)")
    private String width;
    @Option(name="--alerts-policy", usage="The default behaviour for unexpected alerts (accept/ignore/dismiss)")
    private String alertsPolicy;
    @Option(name="--define", aliases={"-D"}, metaVar="<key>[:<type>][+]=<value>", usage="define parameters for capabilities. <type> is a value type: str (default), int or bool (multiple)")
    private String[] define;
    @Option(name="--var", aliases={"-V"}, metaVar="<var-name>=<json-value>", usage="set JSON value to variable with a specified name. (multiple)")
    private String[] var;
    @Option(name="--rollup", metaVar="<file>", usage="define rollup rule by JavaScript. (multiple)")
    private String[] rollup;
    @Option(name="--cookie-filter", metaVar="<+RE|-RE>", usage="filter cookies to log by RE matching the name. (\"+\" is passing, \"-\" is suppressing)")
    private String cookieFilter;
    @Option(name="--log-filter", metaVar="<+type|-type>", usage="filter the logging information by the specified type. (multiple. \"+\" is passing, \"-\" is suppressing. type: cookie, title, url, pageinfo(= cookie & title & url))")
    private String[] logFilter;
    @Option(name="--command-factory", metaVar="<FQCN>", usage="register user defined command factory. (See Note *3)")
    private String commandFactory;
    @Option(name="--no-exit", usage="don't call System.exit at end.")
    private Boolean noExit;
    @Option(name="--strict-exit-code", usage="return strict exit code, reflected by selenese command results at end. (See Note *4)")
    private Boolean strictExitCode;
    @Option(name="--max-time", metaVar="<max-time>", usage="Maximum time in seconds that you allow the entire operation to take.")
    private String maxTime;
    @Option(name="--screenshot-scroll-timeout", metaVar="<timeout>", usage="set scroll timeout (ms) for taking screenshot. (default: 100)")
    private String screenshotTimeout;
    @Option(name="--help", aliases={"-h"}, usage="show this message.")
    private Boolean help;
    @Argument
    private String[] args = LangUtils.EMPTY_STRING_ARRAY;
    private final OptionMap optionMap = new OptionMap(this);
    private static final Pattern RE = Pattern.compile("#.*|([\\w\\-]+)\\s*:\\s*(.*?)\\s*|\\s+(.*?)\\s*");
    private static final Pattern NOTE_RE = Pattern.compile("(\\*\\d+\\s+)(.*)");

    private static String statusListItem(Result.Level level) {
        return String.format("- %d/%d: %s", level.strictExitCode, level.exitCode, level.name());
    }

    public DefaultConfig(String ... args) {
        String columns = System.getProperty("columns", System.getenv("COLUMNS"));
        this.helpWidth = columns != null && columns.matches("\\d+") ? Integer.parseInt(columns) : 80;
        ParserProperties props = ParserProperties.defaults().withOptionSorter(null).withUsageWidth(this.helpWidth).withShowDefaults(false);
        this.parser = new CmdLineParser((Object)this, props);
        if (args.length > 0) {
            this.parseCommandLine(args);
        }
    }

    @Override
    public String getDriver() {
        return this.driver != null ? this.driver : (this.parentOptions != null ? this.parentOptions.getDriver() : null);
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Override
    public boolean isHeadless() {
        return this.headless != null ? this.headless : (this.parentOptions != null ? this.parentOptions.isHeadless() : false);
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    @Override
    public String getProfile() {
        return this.profile != null ? this.profile : (this.parentOptions != null ? this.parentOptions.getProfile() : null);
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Override
    public String getProfileDir() {
        return this.profileDir != null ? this.profileDir : (this.parentOptions != null ? this.parentOptions.getProfileDir() : null);
    }

    public void setProfileDir(String profileDir) {
        this.profileDir = profileDir;
    }

    @Override
    public String getChromeExperimentalOptions() {
        return this.chromeExperimentalOptions != null ? this.chromeExperimentalOptions : (this.parentOptions != null ? this.parentOptions.getChromeExperimentalOptions() : null);
    }

    public void setChromeExperimentalOptions(String chromeExperimentalOptions) {
        this.chromeExperimentalOptions = chromeExperimentalOptions;
    }

    @Override
    public String[] getChromeExtension() {
        return this.chromeExtension != null ? this.chromeExtension : (this.parentOptions != null ? this.parentOptions.getChromeExtension() : null);
    }

    public void addChromeExtension(String chromeExtensionItem) {
        this.chromeExtension = (String[])ArrayUtils.add((Object[])this.chromeExtension, (Object)chromeExtensionItem);
    }

    @Override
    public String getProxyType() {
        return this.proxyType != null ? this.proxyType : (this.parentOptions != null ? this.parentOptions.getProxyType() : null);
    }

    @Override
    public String getProxy() {
        return this.proxy != null ? this.proxy : (this.parentOptions != null ? this.parentOptions.getProxy() : null);
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    @Override
    public String getProxyUser() {
        return this.proxyUser != null ? this.proxyUser : (this.parentOptions != null ? this.parentOptions.getProxyUser() : null);
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword != null ? this.proxyPassword : (this.parentOptions != null ? this.parentOptions.getProxyPassword() : null);
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Override
    public String getNoProxy() {
        return this.noProxy != null ? this.noProxy : (this.parentOptions != null ? this.parentOptions.getNoProxy() : null);
    }

    public void setNoProxy(String noProxy) {
        this.noProxy = noProxy;
    }

    @Override
    public String[] getCliArgs() {
        return this.cliArgs != null ? this.cliArgs : (this.parentOptions != null ? this.parentOptions.getCliArgs() : null);
    }

    public void addCliArgs(String cliArgsItem) {
        this.cliArgs = (String[])ArrayUtils.add((Object[])this.cliArgs, (Object)cliArgsItem);
    }

    @Override
    public String getRemoteUrl() {
        return this.remoteUrl != null ? this.remoteUrl : (this.parentOptions != null ? this.parentOptions.getRemoteUrl() : null);
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    @Override
    public String getRemotePlatform() {
        return this.remotePlatform != null ? this.remotePlatform : (this.parentOptions != null ? this.parentOptions.getRemotePlatform() : null);
    }

    public void setRemotePlatform(String remotePlatform) {
        this.remotePlatform = remotePlatform;
    }

    @Override
    public String getRemoteBrowser() {
        return this.remoteBrowser != null ? this.remoteBrowser : (this.parentOptions != null ? this.parentOptions.getRemoteBrowser() : null);
    }

    public void setRemoteBrowser(String remoteBrowser) {
        this.remoteBrowser = remoteBrowser;
    }

    @Override
    public String getRemoteVersion() {
        return this.remoteVersion != null ? this.remoteVersion : (this.parentOptions != null ? this.parentOptions.getRemoteVersion() : null);
    }

    public void setRemoteVersion(String remoteVersion) {
        this.remoteVersion = remoteVersion;
    }

    @Override
    public boolean isHighlight() {
        return this.highlight != null ? this.highlight : (this.parentOptions != null ? this.parentOptions.isHighlight() : false);
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    @Override
    public boolean isInteractive() {
        return this.interactive != null ? this.interactive : (this.parentOptions != null ? this.parentOptions.isInteractive() : false);
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public String getScreenshotDir() {
        return this.screenshotDir != null ? this.screenshotDir : (this.parentOptions != null ? this.parentOptions.getScreenshotDir() : null);
    }

    public void setScreenshotDir(String screenshotDir) {
        this.screenshotDir = screenshotDir;
    }

    @Override
    public String getScreenshotAll() {
        return this.screenshotAll != null ? this.screenshotAll : (this.parentOptions != null ? this.parentOptions.getScreenshotAll() : null);
    }

    public void setScreenshotAll(String screenshotAll) {
        this.screenshotAll = screenshotAll;
    }

    @Override
    public String getScreenshotOnFail() {
        return this.screenshotOnFail != null ? this.screenshotOnFail : (this.parentOptions != null ? this.parentOptions.getScreenshotOnFail() : null);
    }

    public void setScreenshotOnFail(String screenshotOnFail) {
        this.screenshotOnFail = screenshotOnFail;
    }

    @Override
    public boolean isIgnoreScreenshotCommand() {
        return this.ignoreScreenshotCommand != null ? this.ignoreScreenshotCommand : (this.parentOptions != null ? this.parentOptions.isIgnoreScreenshotCommand() : false);
    }

    public void setIgnoreScreenshotCommand(boolean ignoreScreenshotCommand) {
        this.ignoreScreenshotCommand = ignoreScreenshotCommand;
    }

    @Override
    public String getBaseurl() {
        return this.baseurl != null ? this.baseurl : (this.parentOptions != null ? this.parentOptions.getBaseurl() : null);
    }

    public void setBaseurl(String baseurl) {
        this.baseurl = baseurl;
    }

    @Override
    public String getFirefox() {
        return this.firefox != null ? this.firefox : (this.parentOptions != null ? this.parentOptions.getFirefox() : null);
    }

    public void setFirefox(String firefox) {
        this.firefox = firefox;
    }

    @Override
    public String getGeckodriver() {
        return this.geckodriver != null ? this.geckodriver : (this.parentOptions != null ? this.parentOptions.getGeckodriver() : null);
    }

    public void setGeckodriver(String geckodriver) {
        this.geckodriver = geckodriver;
    }

    @Override
    public String getChromedriver() {
        return this.chromedriver != null ? this.chromedriver : (this.parentOptions != null ? this.parentOptions.getChromedriver() : null);
    }

    public void setChromedriver(String chromedriver) {
        this.chromedriver = chromedriver;
    }

    @Override
    public String getIedriver() {
        return this.iedriver != null ? this.iedriver : (this.parentOptions != null ? this.parentOptions.getIedriver() : null);
    }

    public void setIedriver(String iedriver) {
        this.iedriver = iedriver;
    }

    @Override
    public String getEdgedriver() {
        return this.edgedriver != null ? this.edgedriver : (this.parentOptions != null ? this.parentOptions.getEdgedriver() : null);
    }

    public void setEdgedriver(String edgedriver) {
        this.edgedriver = edgedriver;
    }

    @Override
    public String getPhantomjs() {
        return this.phantomjs != null ? this.phantomjs : (this.parentOptions != null ? this.parentOptions.getPhantomjs() : null);
    }

    public void setPhantomjs(String phantomjs) {
        this.phantomjs = phantomjs;
    }

    @Override
    public String getXmlResult() {
        return this.xmlResult != null ? this.xmlResult : (this.parentOptions != null ? this.parentOptions.getXmlResult() : null);
    }

    public void setXmlResult(String xmlResult) {
        this.xmlResult = xmlResult;
    }

    @Override
    public String getHtmlResult() {
        return this.htmlResult != null ? this.htmlResult : (this.parentOptions != null ? this.parentOptions.getHtmlResult() : null);
    }

    public void setHtmlResult(String htmlResult) {
        this.htmlResult = htmlResult;
    }

    @Override
    public String getTimeout() {
        return this.timeout != null ? this.timeout : (this.parentOptions != null ? this.parentOptions.getTimeout() : null);
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getMaxRetries() {
        return this.maxRetries != null ? this.maxRetries : (this.parentOptions != null ? this.parentOptions.getMaxRetries() : null);
    }

    public void setMaxRetries(String maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public String getSetSpeed() {
        return this.setSpeed != null ? this.setSpeed : (this.parentOptions != null ? this.parentOptions.getSetSpeed() : null);
    }

    public void setSetSpeed(String setSpeed) {
        this.setSpeed = setSpeed;
    }

    @Override
    public String getHeight() {
        return this.height != null ? this.height : (this.parentOptions != null ? this.parentOptions.getHeight() : null);
    }

    public void setHeight(String height) {
        this.height = height;
    }

    @Override
    public String getWidth() {
        return this.width != null ? this.width : (this.parentOptions != null ? this.parentOptions.getWidth() : null);
    }

    public void setWidth(String width) {
        this.width = width;
    }

    @Override
    public String getAlertsPolicy() {
        return this.alertsPolicy != null ? this.alertsPolicy : (this.parentOptions != null ? this.parentOptions.getAlertsPolicy() : null);
    }

    public void setAlertsPolicy(String alertsPolicy) {
        this.alertsPolicy = alertsPolicy;
    }

    @Override
    public String[] getDefine() {
        return this.define != null ? this.define : (this.parentOptions != null ? this.parentOptions.getDefine() : null);
    }

    public void addDefine(String defineItem) {
        this.define = (String[])ArrayUtils.add((Object[])this.define, (Object)defineItem);
    }

    @Override
    public String[] getVar() {
        return this.var != null ? this.var : (this.parentOptions != null ? this.parentOptions.getVar() : null);
    }

    public void addVar(String expr) {
        this.var = (String[])ArrayUtils.add((Object[])this.var, (Object)expr);
    }

    @Override
    public String[] getRollup() {
        return this.rollup != null ? this.rollup : (this.parentOptions != null ? this.parentOptions.getRollup() : null);
    }

    public void addRollup(String rollupItem) {
        this.rollup = (String[])ArrayUtils.add((Object[])this.rollup, (Object)rollupItem);
    }

    @Override
    public String getCookieFilter() {
        return this.cookieFilter != null ? this.cookieFilter : (this.parentOptions != null ? this.parentOptions.getCookieFilter() : null);
    }

    @Override
    public String[] getLogFilter() {
        return this.logFilter != null ? this.logFilter : (this.parentOptions != null ? this.parentOptions.getLogFilter() : null);
    }

    public void addLogFilter(String logFilter) {
        this.logFilter = (String[])ArrayUtils.add((Object[])this.logFilter, (Object)logFilter);
    }

    public void setCookieFilter(String cookieFilter) {
        this.cookieFilter = cookieFilter;
    }

    @Override
    public String getCommandFactory() {
        return this.commandFactory != null ? this.commandFactory : (this.parentOptions != null ? this.parentOptions.getCommandFactory() : null);
    }

    public void setCommandFactory(String commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public String getScreenshotScrollTimeout() {
        return this.screenshotTimeout != null ? this.screenshotTimeout : (this.parentOptions != null ? this.parentOptions.getScreenshotScrollTimeout() : null);
    }

    public void setScreenshotTimeout(String timeout) {
        this.screenshotTimeout = timeout;
    }

    @Override
    public boolean isNoExit() {
        return this.noExit != null ? this.noExit : (this.parentOptions != null ? this.parentOptions.isNoExit() : false);
    }

    public void setNoExit(boolean noExit) {
        this.noExit = noExit;
    }

    @Override
    public boolean isStrictExitCode() {
        return this.strictExitCode != null ? this.strictExitCode : (this.parentOptions != null ? this.parentOptions.isStrictExitCode() : false);
    }

    public void setStrictExitCode(boolean strictExitCode) {
        this.strictExitCode = strictExitCode;
    }

    @Override
    public String getMaxTime() {
        return this.maxTime != null ? this.maxTime : (this.parentOptions != null ? this.parentOptions.getMaxTime() : null);
    }

    public void setMaxTime(String maxTime) {
        this.maxTime = maxTime;
    }

    @Override
    public boolean isHelp() {
        return this.help != null ? this.help : (this.parentOptions != null ? this.parentOptions.isHelp() : false);
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public IConfig parseCommandLine(String ... args) {
        try {
            this.parser.parseArgument(args);
            if (this.config != null) {
                this.parentOptions = new DefaultConfig(new String[0]).loadFrom(this.config);
            }
            if (args == null) {
                args = LangUtils.EMPTY_STRING_ARRAY;
            }
            return this;
        }
        catch (CmdLineException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public IConfig loadFrom(String file) {
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            int cnt = 0;
            String currentKey = null;
            while ((line = r.readLine()) != null) {
                String value;
                ++cnt;
                if (line.isEmpty()) continue;
                Matcher matcher = RE.matcher(line);
                if (!matcher.matches()) {
                    throw new RuntimeException(file + ":" + cnt + ": Invalid format: " + line);
                }
                String key = matcher.group(1);
                if (key != null) {
                    currentKey = key;
                    value = matcher.group(2);
                    if (Strings.isNullOrEmpty((String)value)) continue;
                    this.setOrAddOptionValue(currentKey, value);
                    continue;
                }
                if (currentKey == null || Strings.isNullOrEmpty((String)(value = matcher.group(3)))) continue;
                this.setOrAddOptionValue(currentKey, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void setOrAddOptionValue(String name, String value) {
        Class<?> type = this.optionMap.get((Object)name).type;
        if (type == String.class) {
            this.set(name, value);
        } else if (type == String[].class) {
            this.add(name, value);
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            this.set(name, BooleanUtils.toBoolean((String)value));
        } else {
            throw new UnsupportedOperationException(String.format("Can't set \"%s\" to option \"%s\" (%s)", value, name, type));
        }
    }

    @Override
    public <T> T get(String name) {
        return this.optionMap.get(name).get(this);
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        Object result = this.optionMap.get(name).get(this);
        return result != null ? result : defaultValue;
    }

    public void set(String name, Object value) {
        this.optionMap.get(name).set(this, value);
    }

    public void add(String name, String value) {
        this.optionMap.get(name).add(this, value);
    }

    public void showHelp(PrintWriter pw, String title, String version, String cmdName, String ... msgs) {
        if (msgs.length > 0) {
            for (String msg : msgs) {
                System.out.println(msg);
            }
            System.out.println();
        }
        int width = this.helpWidth - 2;
        String seleniumVersion = SystemInformation.getInstance().getSeleniumVersion();
        pw.println(WordUtils.wrap((String)(title + " " + version + " (with Selenium " + seleniumVersion + ")"), (int)width));
        pw.println();
        for (String line : HEADER) {
            if (line.isEmpty()) {
                pw.println();
                continue;
            }
            pw.println(WordUtils.wrap((String)line, (int)width));
        }
        pw.println();
        this.parser.printUsage((Writer)pw, null);
        pw.println();
        String padding = "";
        for (String line : FOOTER) {
            if (line.isEmpty()) {
                padding = "";
                pw.println();
                continue;
            }
            Matcher m = NOTE_RE.matcher(line);
            if (m.matches()) {
                String mark = m.group(1);
                padding = Strings.repeat((String)" ", (int)mark.length());
                String desc = WordUtils.wrap((String)m.group(2), (int)(width - mark.length()), (String)"\n", (boolean)false).replace("\n", System.lineSeparator() + padding);
                pw.print(mark);
                pw.print(desc);
                pw.println();
                continue;
            }
            pw.print(padding);
            pw.println(WordUtils.wrap((String)line, (int)(width - padding.length()), (String)"\n", (boolean)false).replace("\n", System.lineSeparator() + padding));
        }
        pw.flush();
    }
}

